/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.http;

import com.sysdig.jenkins.plugins.sysdig.infrastructure.http.RemoteDownloader;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class RetriableRemoteDownloader
extends RemoteDownloader {
    private final int maxRetries;
    private final long sleepSeconds;

    public RetriableRemoteDownloader(@NonNull RunContext runContext) {
        super(runContext);
        this.maxRetries = 5;
        this.sleepSeconds = 2L;
    }

    @Override
    public FilePath downloadFile(URL url, String fileName) throws IOException, InterruptedException {
        int downloadRetriesLeft = this.maxRetries;
        while (true) {
            try {
                return super.downloadFile(url, fileName);
            }
            catch (Exception e) {
                if (--downloadRetriesLeft > 0) {
                    this.logger.logWarn(String.format("Error downloading the file, retrying in %d seconds... (%d retries left)", this.sleepSeconds, downloadRetriesLeft));
                    TimeUnit.SECONDS.sleep(this.sleepSeconds);
                    continue;
                }
                throw new IOException("Error downloading the executable file", e);
            }
            break;
        }
    }
}

