package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1;

import java.util.List;
import java.util.Optional;

record JsonVulnerability(
        JsonCvssScore cvssScore,
        String disclosureDate,
        boolean exploitable,
        String fixVersion,
        String mainProvider,
        String name,
        String packageRef,
        List<String> riskAcceptRefs,
        String severity,
        String solutionDate) {
    public Optional<String> optSolutionDate() {
        // Somehow, the solutionDate in v1 format is always filled, but
        // the date is not correct, because it's not actually fixable.
        // The only way we have currently to check this is fixable is by
        // checking if there's a fixVersion defined in the json.
        if (fixVersion == null || fixVersion.isBlank()) {
            return Optional.empty();
        }
        return Optional.ofNullable(solutionDate);
    }

    @Override
    public List<String> riskAcceptRefs() {
        return Optional.ofNullable(riskAcceptRefs).orElse(List.of());
    }
}
