/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningConfig;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ImageScanner;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.http.RetriableRemoteDownloader;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.RemoteSysdigImageScanner;
import edu.umd.cs.findbugs.annotations.NonNull;

public class SysdigImageScanner
implements ImageScanner {
    protected final ImageScanningConfig config;
    private final RunContext runContext;

    public SysdigImageScanner(@NonNull RunContext runContext, @NonNull ImageScanningConfig config) {
        this.runContext = runContext;
        this.config = config;
    }

    @Override
    public ScanResult scanImage(String imageTag) throws InterruptedException {
        try {
            RetriableRemoteDownloader downloader = new RetriableRemoteDownloader(this.runContext);
            RemoteSysdigImageScanner task = new RemoteSysdigImageScanner(this.runContext, downloader, imageTag, this.config);
            return task.performScan();
        }
        catch (Exception e) {
            this.runContext.getLogger().logError("Failed to perform inline-scan due to an unexpected error", e);
            throw new InterruptedException("Failed to perform inline-scan due to an unexpected error. Please refer to above logs for more information");
        }
    }
}

