/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.log;

import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.Date;

public class ConsoleLog
implements SysdigLogger {
    private static final long serialVersionUID = 1L;
    private static final String LOG_FORMAT = "%1$tY-%1$tm-%1$tdT%1$tH:%1$tM:%1$tS.%1$tL %2$-6s %3$-15s %4$s%n";
    private final String name;
    private final boolean enableDebug;
    private final TaskListener listener;
    private transient PrintStream _logger;

    public ConsoleLog(String name, TaskListener listener, boolean enableDebug) {
        this.name = name;
        this.listener = listener;
        this.enableDebug = enableDebug;
    }

    private PrintStream getLogger() {
        if (this._logger == null) {
            this._logger = this.listener.getLogger();
        }
        return this._logger;
    }

    @Override
    public void logDebug(String msg) {
        if (this.enableDebug) {
            this.getLogger().printf(LOG_FORMAT, new Date(), "DEBUG", this.name, msg);
        }
    }

    @Override
    public void logDebug(String msg, Throwable t) {
        this.logDebug(msg);
        if (this.enableDebug && null != t) {
            t.printStackTrace(this.getLogger());
        }
    }

    @Override
    public void logInfo(String msg) {
        this.getLogger().printf(LOG_FORMAT, new Date(), "INFO", this.name, msg);
    }

    @Override
    public void logInfo(String msg, Throwable t) {
        this.logInfo(msg);
        if (null != t) {
            t.printStackTrace(this.getLogger());
        }
    }

    @Override
    public void logWarn(String msg) {
        this.getLogger().printf(LOG_FORMAT, new Date(), "WARN", this.name, msg);
    }

    @Override
    public void logWarn(String msg, Throwable t) {
        this.logWarn(msg);
        if (null != t) {
            t.printStackTrace(this.getLogger());
        }
    }

    @Override
    public void logError(String msg) {
        this.getLogger().printf(LOG_FORMAT, new Date(), "ERROR", this.name, msg);
    }

    @Override
    public void logError(String msg, Throwable t) {
        this.logError(msg);
        if (null != t) {
            t.printStackTrace(this.getLogger());
        }
    }
}

