/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Policy;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRule;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class PolicyBundle
implements AggregateChild<ScanResult>,
Serializable {
    private final ScanResult root;
    private final String id;
    private final String name;
    private final LinkedHashSet<PolicyBundleRule> rules;
    private final Set<Policy> foundInPolicies;

    PolicyBundle(String id, String name, ScanResult root) {
        this.id = id;
        this.name = name;
        this.rules = new LinkedHashSet();
        this.root = root;
        this.foundInPolicies = new HashSet<Policy>();
    }

    void addPolicy(Policy policy) {
        if (this.foundInPolicies.add(policy)) {
            policy.addBundle(this);
        }
    }

    public PolicyBundleRule addRule(String id, String description, EvaluationResult evaluationResult) {
        PolicyBundleRule rule = new PolicyBundleRule(id, description, evaluationResult, this);
        this.rules.add(rule);
        return rule;
    }

    public Set<Policy> foundInPolicies() {
        return Collections.unmodifiableSet(this.foundInPolicies);
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Set<PolicyBundleRule> rules() {
        return Collections.unmodifiableSet(this.rules);
    }

    public EvaluationResult evaluationResult() {
        boolean allRulesPassed = this.rules().stream().allMatch(r -> r.evaluationResult().isPassed());
        return allRulesPassed ? EvaluationResult.Passed : EvaluationResult.Failed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyBundle that = (PolicyBundle)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

