/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundle;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Policy
implements AggregateChild<ScanResult>,
Serializable {
    private final String id;
    private final String name;
    private final Date createdAt;
    private final Date updatedAt;
    private final ScanResult root;
    private final Set<PolicyBundle> bundles;

    public Policy(String id, String name, Date createdAt, Date updatedAt, ScanResult root) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.bundles = new HashSet<PolicyBundle>();
        this.root = root;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    void addBundle(PolicyBundle policyBundle) {
        if (this.bundles.add(policyBundle)) {
            policyBundle.addPolicy(this);
        }
    }

    public Set<PolicyBundle> bundles() {
        return Collections.unmodifiableSet(this.bundles);
    }

    public EvaluationResult evaluationResult() {
        boolean allBundlesPassed = this.bundles().stream().allMatch(b -> b.evaluationResult().isPassed());
        return allBundlesPassed ? EvaluationResult.Passed : EvaluationResult.Failed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.id, policy.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

