/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.sshsteps.util.SSHMasterToSlaveCallable;
import org.jenkinsci.plugins.sshsteps.util.SSHStepDescriptorImpl;
import org.jenkinsci.plugins.sshsteps.util.SSHStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GetStep
extends BasicSSHStep {
    private static final long serialVersionUID = -8831609599645560972L;
    private final String from;
    private final String into;
    @DataBoundSetter
    private String filterBy = "name";
    @DataBoundSetter
    private String filterRegex;
    @DataBoundSetter
    private boolean override = false;

    @DataBoundConstructor
    public GetStep(String from, String into) {
        this.from = from;
        this.into = into;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getInto() {
        return this.into;
    }

    @Generated
    public String getFilterBy() {
        return this.filterBy;
    }

    @Generated
    public String getFilterRegex() {
        return this.filterRegex;
    }

    @Generated
    public boolean isOverride() {
        return this.override;
    }

    @Generated
    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    @Generated
    public void setFilterRegex(String filterRegex) {
        this.filterRegex = filterRegex;
    }

    @Generated
    public void setOverride(boolean override) {
        this.override = override;
    }

    public static class Execution
    extends SSHStepExecution {
        private static final long serialVersionUID = 8544114488028417422L;

        protected Execution(GetStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        protected Object run() throws Exception {
            GetStep step = (GetStep)this.getStep();
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            if (Util.fixEmpty((String)step.getFrom()) == null) {
                throw new IllegalArgumentException("from is null or empty");
            }
            if (Util.fixEmpty((String)step.getInto()) == null) {
                throw new IllegalArgumentException("into is null or empty");
            }
            FilePath intoPath = ws.child(step.getInto());
            if (intoPath.exists() && !step.isOverride()) {
                throw new IllegalArgumentException(intoPath.getRemote() + " already exist. Please set override to true just in case.");
            }
            return this.getChannel().call((Callable)new GetCallable(step, this.getListener(), intoPath.getRemote()));
        }

        private static class GetCallable
        extends SSHMasterToSlaveCallable {
            private final String into;

            public GetCallable(GetStep step, TaskListener listener, String into) {
                super(step, listener);
                this.into = into;
            }

            @Override
            public Object execute() {
                GetStep step = (GetStep)this.getStep();
                return this.getService().get(step.getFrom(), this.into, step.getFilterBy(), step.getFilterRegex());
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SSHStepDescriptorImpl {
        public String getFunctionName() {
            return "sshGet";
        }

        @NonNull
        public String getDisplayName() {
            return this.getPrefix() + this.getFunctionName() + " - Get a file or directory from remote node.";
        }
    }
}

