/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.verifiers.KnownHostsFileKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.ManuallyProvidedKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.ManuallyTrustedKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.ComputerConnector;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class VerificationStrategyConfigurationTest {
    VerificationStrategyConfigurationTest() {
    }

    @Test
    void testConfigureRoundTripManualTrustedStrategy(JenkinsRule jenkins) throws Exception {
        VerificationStrategyConfigurationTest.testConfigureRoundTrip(jenkins, (SshHostKeyVerificationStrategy)new ManuallyTrustedKeyVerificationStrategy(true));
    }

    @Test
    void testConfigureRoundTripNonVerifyingStrategy(JenkinsRule jenkins) throws Exception {
        VerificationStrategyConfigurationTest.testConfigureRoundTrip(jenkins, (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
    }

    @Test
    void testConfigureRoundTripManualProvidedVerifyingStrategy(JenkinsRule jenkins) throws Exception {
        String key = "AAAAB3NzaC1yc2EAAAADAQABAAABAQC1oF3jpBkexmWgKh7kwMGFjb9L7+/mvY7TNMiobWC4JK8T7fv/gRNMSfY6Fg9INZosfxD+9oktnVl1/9Nc5Qqp3/ia7qtyccXzab6WuNbuos+Ggb14vqLe0SD+Edc1TpBRMg8w70L41uTlgrhHqwzt96BbPe9hG1cfgZ5Lx9JTMZUyXgGaJmShE9Fsa+CJV5bW/Nqc8G/Z8fLKBlUwiX7hQHkG4xVNQve60kDvDVJpozd+XAiZrQVgwCLTg3ik2aDdR9U+VCC7q1s3SgFFf8jh5Z5QAJ2MA+A6oq2rJJoCIfXJnBdXEgHggJf3d1tl1vBI1pOVxDa9BWBjr4KvwgwL";
        VerificationStrategyConfigurationTest.testConfigureRoundTrip(jenkins, (SshHostKeyVerificationStrategy)new ManuallyProvidedKeyVerificationStrategy("ssh-rsa " + key));
    }

    @Test
    void testConfigureRoundTripKnownHostsVerifyingStrategy(JenkinsRule jenkins) throws Exception {
        VerificationStrategyConfigurationTest.testConfigureRoundTrip(jenkins, (SshHostKeyVerificationStrategy)new KnownHostsFileKeyVerificationStrategy());
    }

    private static void testConfigureRoundTrip(JenkinsRule jenkins, SshHostKeyVerificationStrategy strategy) throws Exception {
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, "dummyCredentialId", null, "dummyUser", "dummyPassword");
        ArrayList<UsernamePasswordCredentialsImpl> credentialsList = new ArrayList<UsernamePasswordCredentialsImpl>();
        credentialsList.add(credentials);
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), credentialsList);
        SSHConnector connector = new SSHConnector(12, credentials.getId());
        connector.setSshHostKeyVerificationStrategy(strategy);
        connector.setJvmOptions("jvmOptions");
        connector.setSuffixStartSlaveCmd("suffix");
        connector.setPrefixStartSlaveCmd("prefix");
        connector.setJavaPath("/path");
        connector.setRetryWaitTime(Integer.valueOf(10));
        connector.setMaxNumRetries(Integer.valueOf(10));
        connector.setLaunchTimeoutSeconds(Integer.valueOf(10));
        SSHConnector output = (SSHConnector)jenkins.configRoundtrip((ComputerConnector)connector);
        Assertions.assertNotSame((Object)connector, (Object)output);
        jenkins.assertEqualDataBoundBeans((Object)connector, (Object)output);
    }
}

