/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import hudson.plugins.sshslaves.verifiers.HostKey;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HostKeyTest {
    HostKeyTest() {
    }

    @Test
    void testFingerprintUsesSHA256() {
        byte[] keyBytes = "test-key-data".getBytes();
        HostKey hostKey = new HostKey("ssh-rsa", keyBytes);
        String fingerprint = hostKey.getFingerprint();
        Assertions.assertTrue((boolean)fingerprint.startsWith("SHA256:"), (String)"Fingerprint should use SHA256 format");
        String base64Part = fingerprint.substring(7);
        Assertions.assertDoesNotThrow(() -> Base64.getDecoder().decode(base64Part), (String)"Fingerprint should be valid Base64 after SHA256: prefix");
    }

    @Test
    void testFingerprintFormat() {
        byte[] keyBytes = "test-key-data".getBytes();
        HostKey hostKey = new HostKey("ssh-rsa", keyBytes);
        String fingerprint = hostKey.getFingerprint();
        Assertions.assertTrue((boolean)fingerprint.matches("SHA256:[A-Za-z0-9+/=]+"), (String)"Fingerprint should match SHA256:Base64 format");
    }
}

