/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import java.io.File;
import java.io.PrintStream;
import java.util.EnumMap;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationFileWriter {
    private final File m_file;

    public ConfigurationFileWriter(File file) {
        assert (file != null) : "Parameter 'file' of method 'ConfigurationFileWriter' must not be null";
        this.m_file = file;
    }

    public void createConfigurationFile(EnumMap<SonargraphBuildParameter, String> parameters, PrintStream logger) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element sonargraphBuild = doc.createElement("sonargraphBuild");
            doc.appendChild(sonargraphBuild);
            this.setStartupAttributes(sonargraphBuild, parameters);
            Element failSet = doc.createElement("failSet");
            sonargraphBuild.appendChild(failSet);
            failSet.setAttribute("failOnEmptyWorkspace", "false");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.m_file);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to create configuration file '", pce);
        }
        catch (TransformerException tfe) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to create configuration file '", tfe);
        }
    }

    private void setStartupAttributes(Element element, EnumMap<SonargraphBuildParameter, String> params) {
        for (SonargraphBuildParameter parameter : params.keySet()) {
            String value = params.get((Object)parameter);
            if (value == null) continue;
            element.setAttribute(parameter.getPresentationName(), value);
        }
    }

    public static final class SonargraphBuildParameter
    extends Enum<SonargraphBuildParameter> {
        public static final /* enum */ SonargraphBuildParameter ACTIVATION_CODE = new SonargraphBuildParameter("activationCode");
        public static final /* enum */ SonargraphBuildParameter INSTALLATION_DIRECTORY = new SonargraphBuildParameter("installationDirectory");
        public static final /* enum */ SonargraphBuildParameter LANGUAGES = new SonargraphBuildParameter("languages");
        public static final /* enum */ SonargraphBuildParameter SYSTEM_DIRECTORY = new SonargraphBuildParameter("systemDirectory");
        public static final /* enum */ SonargraphBuildParameter REPORT_DIRECTORY = new SonargraphBuildParameter("reportDirectory");
        public static final /* enum */ SonargraphBuildParameter REPORT_FILENAME = new SonargraphBuildParameter("reportFileName");
        public static final /* enum */ SonargraphBuildParameter REPORT_BASELINE = new SonargraphBuildParameter("baselineReportPath");
        public static final /* enum */ SonargraphBuildParameter REPORT_TYPE = new SonargraphBuildParameter("reportType");
        public static final /* enum */ SonargraphBuildParameter REPORT_FORMAT = new SonargraphBuildParameter("reportFormat");
        public static final /* enum */ SonargraphBuildParameter QUALITY_MODEL_FILE = new SonargraphBuildParameter("qualityModelFile");
        public static final /* enum */ SonargraphBuildParameter VIRTUAL_MODEL = new SonargraphBuildParameter("virtualModel");
        public static final /* enum */ SonargraphBuildParameter LICENSE_FILE = new SonargraphBuildParameter("licenseFile");
        public static final /* enum */ SonargraphBuildParameter WORKSPACE_PROFILE = new SonargraphBuildParameter("workspaceProfile");
        public static final /* enum */ SonargraphBuildParameter SNAPSHOT_DIRECTORY = new SonargraphBuildParameter("snapshotDirectory");
        public static final /* enum */ SonargraphBuildParameter SNAPSHOT_FILE_NAME = new SonargraphBuildParameter("snapshotFileName");
        public static final /* enum */ SonargraphBuildParameter LOG_FILE = new SonargraphBuildParameter("logFile");
        public static final /* enum */ SonargraphBuildParameter LOG_LEVEL = new SonargraphBuildParameter("logLevel");
        public static final /* enum */ SonargraphBuildParameter LICENSE_SERVER_HOST = new SonargraphBuildParameter("licenseServerHost");
        public static final /* enum */ SonargraphBuildParameter LICENSE_SERVER_PORT = new SonargraphBuildParameter("licenseServerPort");
        public static final /* enum */ SonargraphBuildParameter ELEMENT_COUNT_TO_SPLIT_HTML_REPORT = new SonargraphBuildParameter("elementCountToSplitHtmlReport");
        public static final /* enum */ SonargraphBuildParameter PROGRESS_INFO = new SonargraphBuildParameter("progressInfo");
        public static final /* enum */ SonargraphBuildParameter PROXY_HOST = new SonargraphBuildParameter("proxyHost");
        public static final /* enum */ SonargraphBuildParameter PROXY_PORT = new SonargraphBuildParameter("proxyPort");
        public static final /* enum */ SonargraphBuildParameter PROXY_USERNAME = new SonargraphBuildParameter("proxyUsername");
        public static final /* enum */ SonargraphBuildParameter PROXY_PASSWORD = new SonargraphBuildParameter("proxyPassword");
        private final String m_presentationName;
        private static final /* synthetic */ SonargraphBuildParameter[] $VALUES;

        public static SonargraphBuildParameter[] values() {
            return (SonargraphBuildParameter[])$VALUES.clone();
        }

        public static SonargraphBuildParameter valueOf(String name) {
            return Enum.valueOf(SonargraphBuildParameter.class, name);
        }

        private SonargraphBuildParameter(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'MandatoryParameter' must not be empty";
            this.m_presentationName = presentationName;
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }

        private static /* synthetic */ SonargraphBuildParameter[] $values() {
            return new SonargraphBuildParameter[]{ACTIVATION_CODE, INSTALLATION_DIRECTORY, LANGUAGES, SYSTEM_DIRECTORY, REPORT_DIRECTORY, REPORT_FILENAME, REPORT_BASELINE, REPORT_TYPE, REPORT_FORMAT, QUALITY_MODEL_FILE, VIRTUAL_MODEL, LICENSE_FILE, WORKSPACE_PROFILE, SNAPSHOT_DIRECTORY, SNAPSHOT_FILE_NAME, LOG_FILE, LOG_LEVEL, LICENSE_SERVER_HOST, LICENSE_SERVER_PORT, ELEMENT_COUNT_TO_SPLIT_HTML_REPORT, PROGRESS_INFO, PROXY_HOST, PROXY_PORT, PROXY_USERNAME, PROXY_PASSWORD};
        }

        static {
            $VALUES = SonargraphBuildParameter.$values();
        }
    }
}

