/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.model;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.model.AbstractPlot;
import com.hello2morrow.sonargraph.integration.jenkins.model.BuildDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.model.InvalidDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.MovingAverage;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class TimeSeriesPlot
extends AbstractPlot {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private static final int MOVING_AVG_PERIOD = 86400000;
    private int m_markerPosition = 0;
    private long m_markerTimestamp = 0L;

    public TimeSeriesPlot(IMetricHistoryProvider dataProvider, int markerPosition) {
        super(dataProvider);
        this.m_markerPosition = markerPosition;
    }

    @Override
    protected JFreeChart createChartInternal(String chartTitle, String categoryName, String yAxisName, XYDataset dataset) {
        return ChartFactory.createTimeSeriesChart((String)chartTitle, (String)categoryName, (String)yAxisName, (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
    }

    @Override
    protected XYDataset createXYDataset(MetricId metric, int maximumNumberOfDataPoints) throws IOException {
        assert (metric != null) : "Parameter 'metric' of method 'createXYDataset' must not be null";
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)metric.getName()), FixedMillisecond.class);
        List<IDataPoint> dataset = this.m_datasetProvider.readMetricValues(metric);
        int size = dataset.size();
        SonargraphLogger.INSTANCE.fine(size + " data points found for metric '" + metric.getName() + "' in file '" + this.m_datasetProvider.getStorageName() + "'");
        List<IDataPoint> reducedSet = this.reduceDataSet(dataset, maximumNumberOfDataPoints);
        BuildDataPoint point = null;
        for (IDataPoint datapoint : reducedSet) {
            if (datapoint instanceof InvalidDataPoint || !(datapoint instanceof BuildDataPoint) || (point = (BuildDataPoint)datapoint).getTimestamp() == 0L) continue;
            timeSeries.add((RegularTimePeriod)new FixedMillisecond(point.getTimestamp()), point.getY());
        }
        if (point != null) {
            this.setTimestampOfLastDisplayedPoint(point.getTimestamp());
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries avgDataset = MovingAverage.createMovingAverage((TimeSeries)timeSeries, (String)("Avg of " + metric.getName()), (int)86400000, (int)0);
        this.setDataSetSize(avgDataset.getItemCount());
        timeSeriesCollection.addSeries(avgDataset);
        for (Object item : avgDataset.getItems()) {
            if (!(item instanceof TimeSeriesDataItem)) continue;
            this.checkMinMaxYValue(((TimeSeriesDataItem)item).getValue().doubleValue());
        }
        return timeSeriesCollection;
    }

    private List<IDataPoint> reduceDataSet(List<IDataPoint> dataset, int maxDataPoints) {
        assert (dataset != null) : "Parameter 'dataset' of method 'reduceDataSet' must not be null";
        if (maxDataPoints <= 0) {
            return dataset;
        }
        int size = dataset.size();
        if (size <= maxDataPoints) {
            IDataPoint point;
            if (size > this.m_markerPosition && (point = dataset.get(dataset.size() - this.m_markerPosition)) instanceof BuildDataPoint) {
                this.m_markerTimestamp = ((BuildDataPoint)point).getTimestamp();
            }
            return dataset;
        }
        int compressionFactor = size % maxDataPoints == 0 ? size / maxDataPoints : size / maxDataPoints + 1;
        ArrayList<IDataPoint> compressedSet = new ArrayList<IDataPoint>();
        SonargraphLogger.INSTANCE.log(Level.FINE, "Compressing data set of size '" + size + "' by a factor of '" + compressionFactor + "'");
        for (int i = 0; i < size; i += compressionFactor) {
            double valueSum = 0.0;
            long timestamp = 0L;
            int buildNumber = 0;
            int actualFactor = 0;
            for (int j = 0; j < compressionFactor && i + j < size; ++j) {
                actualFactor = j + 1;
                IDataPoint point = dataset.get(i + j);
                if (point instanceof BuildDataPoint) {
                    valueSum += point.getY();
                    buildNumber = point.getX();
                    timestamp = ((BuildDataPoint)point).getTimestamp();
                    if (i + j != size - this.m_markerPosition) continue;
                    this.m_markerTimestamp = timestamp;
                    continue;
                }
                SonargraphLogger.INSTANCE.log(Level.FINE, "DataPoint [" + (i + j) + "] is of type '" + point.getClass().getName() + "', expect type '" + BuildDataPoint.class.getName() + "'");
            }
            compressedSet.add(new BuildDataPoint(buildNumber, valueSum / (double)actualFactor, timestamp));
        }
        return compressedSet;
    }

    @Override
    protected void applyRendering(XYPlot plot) {
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)DATE_FORMAT);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(false);
        renderer.setSeriesPaint(0, DATA_COLOR);
        if (this.m_markerTimestamp > 0L) {
            ValueMarker target = new ValueMarker((double)this.m_markerTimestamp);
            target.setPaint((Paint)Color.RED);
            target.setLabel("Short Term");
            if (this.m_markerPosition * 2 > this.getDatasetSize()) {
                target.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
                target.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            } else {
                target.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                target.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
            }
            plot.addDomainMarker((Marker)target);
        }
    }
}

