/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.LatestFolder;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.TextFileReader;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Job;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class PipelineReportAction
implements Action {
    private final Job<?, ?> job;

    public PipelineReportAction(Job<?, ?> job) {
        this.job = job;
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_REPORT.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_PIPELINE_REPORT.getValue();
    }

    protected String readHTMLReport(FilePath pathToReport, String alternative) throws IOException, InterruptedException {
        SonargraphLogger.INSTANCE.log(Level.INFO, "Reading Sonargraph HTML Report from '" + String.valueOf(pathToReport) + "'");
        if (pathToReport.exists()) {
            return TextFileReader.readLargeTextFile(pathToReport);
        }
        SonargraphLogger.INSTANCE.log(Level.WARNING, "Unable to read Sonargraph HTML report from '" + String.valueOf(pathToReport) + "'");
        return alternative;
    }

    public String getHTMLReport() throws IOException, InterruptedException {
        File reportFile = LatestFolder.getReport(this.job);
        return this.readHTMLReport(new FilePath(reportFile), "Unable to read Sonargraph HTML report.");
    }
}

