/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.AbstractMsBuildSQRunner;
import hudson.plugins.sonar.Messages;
import hudson.plugins.sonar.MsBuildSQRunnerBegin;
import hudson.plugins.sonar.MsBuildSQRunnerInstallation;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.action.SonarMarkerAction;
import hudson.plugins.sonar.client.HttpClient;
import hudson.plugins.sonar.client.OkHttpClientSingleton;
import hudson.plugins.sonar.utils.BuilderUtils;
import hudson.plugins.sonar.utils.SonarUtils;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class MsBuildSQRunnerEnd
extends AbstractMsBuildSQRunner {
    @DataBoundConstructor
    public MsBuildSQRunnerEnd() {
    }

    @Override
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = BuilderUtils.getEnvAndBuildVars(run, listener);
        AbstractMsBuildSQRunner.SonarQubeScannerMsBuildParams beginParams = (AbstractMsBuildSQRunner.SonarQubeScannerMsBuildParams)run.getAction(AbstractMsBuildSQRunner.SonarQubeScannerMsBuildParams.class);
        if (beginParams == null) {
            throw new AbortException(Messages.MsBuildScannerEnd_NoBeginStep());
        }
        String scannerName = beginParams.getScannerName();
        String sonarInstName = beginParams.getSqServerName();
        SonarInstallation sonarInstallation = MsBuildSQRunnerEnd.getSonarInstallation(sonarInstName, listener);
        MsBuildSQRunnerInstallation msBuildScanner = ((MsBuildSQRunnerBegin.DescriptorImpl)Jenkins.get().getDescriptorByType(MsBuildSQRunnerBegin.DescriptorImpl.class)).getMsBuildScannerInstallation(scannerName);
        String scannerPath = this.getScannerPath(msBuildScanner, env, launcher, listener, workspace);
        if (this.isDotNetCoreTool(scannerPath).booleanValue()) {
            this.addDotNetCommand(args);
        }
        args.add(scannerPath);
        this.addArgs(args, env, sonarInstallation, run);
        int result = launcher.launch().cmds(args).envs((Map)env).stdout(listener).pwd(BuilderUtils.getModuleRoot(run, workspace)).join();
        if (result != 0) {
            MsBuildSQRunnerEnd.addBadge(run, listener, workspace, sonarInstallation);
            throw new AbortException(Messages.MSBuildScanner_ExecFailed(result));
        }
        MsBuildSQRunnerEnd.addBadge(run, listener, workspace, sonarInstallation);
    }

    private void addArgs(ArgumentListBuilder args, EnvVars env, SonarInstallation sonarInstallation, Run<?, ?> run) {
        Map<String, String> props = this.getSonarProps(sonarInstallation, run);
        args.add("end");
        EnvVars.resolve(props);
        for (Map.Entry<String, String> e : props.entrySet()) {
            if (StringUtils.isEmpty((String)e.getValue())) continue;
            boolean hide = e.getKey().contains("sonar.login") || e.getKey().contains("sonar.token");
            args.addKeyValuePair("/d:", e.getKey(), env.expand(e.getValue()), hide);
        }
        args.addTokenized(sonarInstallation.getAdditionalProperties());
    }

    private Map<String, String> getSonarProps(SonarInstallation inst, Run<?, ?> run) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String token = inst.getServerAuthenticationToken(run);
        if (!StringUtils.isBlank((String)token)) {
            map.put(SonarUtils.getTokenProperty(inst, new HttpClient(OkHttpClientSingleton.getInstance())), token);
        }
        return map;
    }

    private static void addBadge(Run<?, ?> run, TaskListener listener, FilePath workspace, SonarInstallation sonarInstallation) throws IOException, InterruptedException {
        SonarUtils.addBuildInfoTo(run, listener, workspace, sonarInstallation);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SonarMarkerAction();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/sonar/help-ms-build-sq-scanner-end.html";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.MsBuildScannerEnd_DisplayName();
        }
    }
}

