/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.sonar.api;

import hudson.util.Secret;
import org.apache.commons.lang.StringUtils;
import org.quality.gates.jenkins.plugin.SonarInstance;

public class SonarInstanceValidationService {
    String validateUrl(SonarInstance sonarInstance) {
        if (sonarInstance.getUrl().isEmpty()) {
            return "http://localhost:9000";
        }
        String url = sonarInstance.getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    String validateUsername(SonarInstance sonarInstance) {
        if (sonarInstance.getUsername().isEmpty()) {
            return "admin";
        }
        return sonarInstance.getUsername();
    }

    private Secret validatePassword(SonarInstance sonarInstance) {
        if (sonarInstance.getPass().getPlainText().isEmpty()) {
            return Secret.fromString((String)"admin");
        }
        return sonarInstance.getPass();
    }

    SonarInstance validateData(SonarInstance sonarInstance) {
        if (sonarInstance.getToken() != null && StringUtils.isNotEmpty((String)sonarInstance.getToken().getPlainText())) {
            return new SonarInstance(sonarInstance.getName(), this.validateUrl(sonarInstance), sonarInstance.getToken(), sonarInstance.getTimeToWait(), sonarInstance.getMaxWaitTime());
        }
        return new SonarInstance(sonarInstance.getName(), this.validateUrl(sonarInstance), this.validateUsername(sonarInstance), this.validatePassword(sonarInstance), sonarInstance.getTimeToWait(), sonarInstance.getMaxWaitTime());
    }
}

