/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.sonar.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.model.BuildListener;
import org.apache.commons.lang.ArrayUtils;
import org.json.JSONException;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.sonar.api.MaxExecutionTimeException;
import org.quality.gates.sonar.api.QualityGateResponseParser;
import org.quality.gates.sonar.api.QualityGateTaskCE;
import org.quality.gates.sonar.api.QualityGatesStatus;
import org.quality.gates.sonar.api.SonarHttpRequester;
import org.quality.gates.sonar.api.SonarHttpRequesterFactory;
import org.quality.gates.sonar.api.SonarInstanceValidationService;

public class QualityGatesProvider {
    private static final int MILLISECONDS_5_MINUTES = 300000;
    private static final int MILLISECONDS_10_SECONDS = 10000;
    private final QualityGateResponseParser qualityGateResponseParser;
    private final SonarHttpRequester sonarHttpRequester;
    private final SonarInstanceValidationService sonarInstanceValidationService;

    public QualityGatesProvider(SonarInstance sonarInstance) {
        this.qualityGateResponseParser = new QualityGateResponseParser();
        this.sonarHttpRequester = SonarHttpRequesterFactory.getSonarHttpRequester(sonarInstance);
        this.sonarInstanceValidationService = new SonarInstanceValidationService();
    }

    public QualityGatesProvider(QualityGateResponseParser qualityGateResponseParser, SonarHttpRequester sonarHttpRequester, SonarInstanceValidationService sonarInstanceValidationService) {
        this.qualityGateResponseParser = qualityGateResponseParser;
        this.sonarHttpRequester = sonarHttpRequester;
        this.sonarInstanceValidationService = sonarInstanceValidationService;
    }

    public QualityGatesStatus getAPIResultsForQualityGates(JobConfigData jobConfigData, SonarInstance sonarInstance, BuildListener listener) throws JSONException, InterruptedException {
        SonarInstance validatedData = this.sonarInstanceValidationService.validateData(sonarInstance);
        boolean taskAnalysisRunning = true;
        int timeToWait = sonarInstance.getTimeToWait();
        int maxWaitTime = sonarInstance.getMaxWaitTime();
        if (timeToWait == 0) {
            timeToWait = 10000;
        }
        if (maxWaitTime == 0) {
            maxWaitTime = 300000;
        }
        long startTime = System.currentTimeMillis();
        do {
            this.sonarHttpRequester.setLogged(false);
            String statusResultJson = this.sonarHttpRequester.getAPITaskInfo(jobConfigData, validatedData);
            Gson gson = new GsonBuilder().create();
            QualityGateTaskCE taskCE = (QualityGateTaskCE)gson.fromJson(statusResultJson, QualityGateTaskCE.class);
            if (ArrayUtils.isNotEmpty((Object[])taskCE.getQueue())) {
                listener.getLogger().println("Has build " + taskCE.getQueue()[0].getStatus() + " with id: " + taskCE.getQueue()[0].getId() + " - waiting " + timeToWait + " to execute next check. DEBUG:" + (System.currentTimeMillis() - startTime));
                Thread.sleep(timeToWait);
            } else {
                listener.getLogger().println("Status => " + taskCE.getCurrent().getStatus());
                if ("SUCCESS".equals(taskCE.getCurrent().getStatus())) {
                    taskAnalysisRunning = false;
                }
            }
            if (System.currentTimeMillis() - startTime <= (long)maxWaitTime) continue;
            throw new MaxExecutionTimeException("Status => Max time to wait sonar job!");
        } while (taskAnalysisRunning);
        String requesterResult = this.getRequesterResult(jobConfigData, validatedData);
        return this.qualityGateResponseParser.getQualityGateResultFromJSON(requesterResult);
    }

    private String getRequesterResult(JobConfigData jobConfigData, SonarInstance sonarInstance) throws QGException {
        return this.sonarHttpRequester.getAPIInfo(jobConfigData, sonarInstance);
    }
}

