/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.sonargerrit.TaskListenerLogger;
import org.jenkinsci.plugins.sonargerrit.gerrit.Revision;
import org.jenkinsci.plugins.sonargerrit.sonar.ByFilenameEndPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SimpleIssue;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarQubeIssueDecorator;

class SonarQubeIssuePathCorrector
implements SonarQubeIssueDecorator {
    private static final Logger LOGGER = Logger.getLogger(SonarQubeIssuePathCorrector.class.getName());
    private final TaskListener listener;
    private final Revision revision;
    private final Map<String, String> inspection2revisionFilepaths;

    public SonarQubeIssuePathCorrector(TaskListener listener, Revision revision) {
        this.listener = listener;
        this.revision = revision;
        this.inspection2revisionFilepaths = new HashMap<String, String>();
    }

    @Override
    public SimpleIssue decorate(SimpleIssue issue) {
        String reviewSystemFilePath = this.findReviewSystemFilepath(issue, this.revision.getChangedFiles());
        if (reviewSystemFilePath != null) {
            issue.setFilepath(reviewSystemFilePath);
        }
        return issue;
    }

    private String findReviewSystemFilepath(Issue i, Set<String> files) {
        String filepath = i.getFilepath();
        if (this.inspection2revisionFilepaths.containsKey(filepath)) {
            return this.inspection2revisionFilepaths.get(filepath);
        }
        if (files.contains(filepath)) {
            this.inspection2revisionFilepaths.put(filepath, filepath);
            return filepath;
        }
        String found = null;
        for (String s : files) {
            if (!this.namesMatch(i, s)) continue;
            if (found == null) {
                found = s;
                continue;
            }
            TaskListenerLogger.logMessage(this.listener, LOGGER, Level.SEVERE, "jenkins.plugin.error.more.than.one.file.matched", i.getFilepath());
            return null;
        }
        return found;
    }

    private boolean namesMatch(Issue issue, String reviewFilepath) {
        return ByFilenameEndPredicate.apply(reviewFilepath).apply(issue);
    }
}

