/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Rule {
    private final String id;

    public Rule(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public String createUrl(String sonarQubeUrl) {
        if (sonarQubeUrl == null) {
            return this.id;
        }
        StringBuilder sb = new StringBuilder();
        String url = sonarQubeUrl.trim();
        if (!url.startsWith("http://") && !sonarQubeUrl.startsWith("https://")) {
            sb.append("http://");
        }
        sb.append(url);
        if (!url.endsWith("/")) {
            sb.append("/");
        }
        sb.append("coding_rules#rule_key=");
        sb.append(this.escapeHttp(this.id));
        return sb.toString();
    }

    private String escapeHttp(String query) {
        try {
            return URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return query;
        }
    }
}

