/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.sonargerrit.sonar.ByChangedLinesPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.ByFilenamesPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.ByGlobPatternPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.ByMinSeverityPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.ByNewPredicate;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.IssueFilterConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class IssueFilter {
    private final IssueFilterConfig filterConfig;
    private final List<Issue> issues;
    private final Map<String, Set<Integer>> changedLines;

    public IssueFilter(IssueFilterConfig filterConfig, List<Issue> issues, Map<String, Set<Integer>> changedLines) {
        this.filterConfig = filterConfig;
        this.issues = issues;
        this.changedLines = changedLines;
    }

    public Iterable<Issue> filter() {
        String excludedPathsGlobPattern;
        String includedPathsGlobPattern;
        Severity severity;
        ArrayList<Object> toBeApplied = new ArrayList<Object>();
        if (this.filterConfig.isChangedLinesOnly()) {
            toBeApplied.add(ByChangedLinesPredicate.apply(this.changedLines));
        } else {
            toBeApplied.add(ByFilenamesPredicate.apply(this.changedLines.keySet()));
        }
        if (this.filterConfig.isNewIssuesOnly()) {
            toBeApplied.add(ByNewPredicate.apply(this.filterConfig.isNewIssuesOnly()));
        }
        if (!Severity.INFO.equals((Object)(severity = Severity.valueOf(this.filterConfig.getSeverity())))) {
            toBeApplied.add(ByMinSeverityPredicate.apply(severity));
        }
        if ((includedPathsGlobPattern = this.filterConfig.getIncludedPathsGlobPattern()) != null && !includedPathsGlobPattern.isEmpty()) {
            toBeApplied.add(new ByGlobPatternPredicate(includedPathsGlobPattern));
        }
        if ((excludedPathsGlobPattern = this.filterConfig.getExcludedPathsGlobPattern()) != null && !excludedPathsGlobPattern.isEmpty()) {
            toBeApplied.add(new ByGlobPatternPredicate(excludedPathsGlobPattern).negate());
        }
        return Iterables.filter(this.issues, (Predicate)Predicates.and(toBeApplied));
    }
}

