package org.jenkinsci.plugins.sonargerrit;

import static org.jenkinsci.plugins.sonargerrit.util.Localization.getLocalized;

import hudson.model.TaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

/**
 * Project: Sonar-Gerrit Plugin Author: Tatiana Didik Created: 28.11.2017 15:08
 *
 * <p>$Id$
 */
@Restricted(NoExternalUse.class)
public class TaskListenerLogger {

  public static void log(TaskListener listener, String message, Object... params) {
    listener.getLogger().printf(message, params);
    listener.getLogger().println();
  }

  public static void logMessage(
      TaskListener listener, Logger logger, Level level, String message, Object... params) {
    message = getLocalized(message, params);

    logMessage(message, listener != null, listener, logger != null, logger, level);
  }

  private static void logMessage(
      String message,
      boolean logToListener,
      TaskListener listener,
      boolean logToLogger,
      Logger logger,
      Level level) {
    if (logToListener) {
      logMessage(listener, message);
    }
    if (logToLogger) {
      logMessage(logger, message, level);
    }
  }

  private static void logMessage(Logger logger, String message, Level level) {
    logger.log(level, message);
  }

  private static void logMessage(TaskListener listener, String message) {
    listener.getLogger().println(message);
  }
}
