/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.config;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.scriptler.config.Script;

public class ScriptSet {
    protected Set<Script> scriptSet = new TreeSet<Script>();

    public Script getScriptById(String id) {
        for (Script scr : this.scriptSet) {
            if (!scr.getId().equals(id)) continue;
            return scr;
        }
        return null;
    }

    public void removeScript(String id) {
        Script s = this.getScriptById(id);
        this.scriptSet.remove(s);
    }

    public void addOrReplace(Script script) {
        if (script != null) {
            Script oldScript = this.getScriptById(script.getId());
            if (oldScript != null) {
                Script mergedScript = this.merge(oldScript, script);
                this.scriptSet.remove(script);
                this.scriptSet.add(mergedScript);
            } else {
                this.scriptSet.add(script);
            }
        }
    }

    private String choose(String preferred, String fallback) {
        if (preferred == null || preferred.isEmpty()) {
            return fallback;
        }
        return preferred;
    }

    private Script merge(Script origin, Script newScript) {
        String name = this.choose(newScript.name, origin.name);
        String comment = this.choose(newScript.comment, origin.comment);
        String originCatalog = this.choose(newScript.originCatalog, origin.originCatalog);
        String originScript = this.choose(newScript.originScript, origin.originScript);
        String originDate = this.choose(newScript.originDate, origin.originDate);
        return new Script(newScript.getId(), name, comment, newScript.isAvailable(), originCatalog, originScript, originDate, newScript.nonAdministerUsing, newScript.getParameters(), newScript.onlyBuiltIn);
    }

    public final Set<Script> getScripts() {
        if (this.scriptSet == null) {
            this.scriptSet = new TreeSet<Script>();
        }
        return Collections.unmodifiableSet(this.scriptSet);
    }

    public final Set<Script> getUserScripts() {
        TreeSet<Script> userScripts = new TreeSet<Script>();
        for (Script script : this.scriptSet) {
            if (!script.nonAdministerUsing) continue;
            userScripts.add(script);
        }
        return userScripts;
    }

    public void setScripts(Set<Script> scripts) {
        if (this.scriptSet == null) {
            this.scriptSet = new TreeSet<Script>();
        }
        this.scriptSet.clear();
        this.scriptSet.addAll(scripts);
    }
}

