/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import java.util.Optional;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.saml.OpenSAMLWrapper;
import org.jenkinsci.plugins.saml.RefererStateGenerator;
import org.jenkinsci.plugins.saml.RelayStateMapper;
import org.jenkinsci.plugins.saml.SamlPluginConfig;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.credentials.SAML2AuthenticationCredentials;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.SAML2Profile;
import org.springframework.security.authentication.BadCredentialsException;

public class SamlProfileWrapper
extends OpenSAMLWrapper<SAML2Profile> {
    private static final Logger LOG = Logger.getLogger(SamlProfileWrapper.class.getName());
    private String redirectUrl;

    public SamlProfileWrapper(SamlPluginConfig samlPluginConfig, StaplerRequest2 request, StaplerResponse2 response) {
        this.request = request;
        this.response = response;
        this.samlPluginConfig = samlPluginConfig;
    }

    @Override
    protected SAML2Profile process() {
        SAML2Profile saml2Profile;
        SAML2AuthenticationCredentials credentials;
        try (SAML2Client client = this.createSAML2Client();){
            WebContext context = this.createWebContext();
            SessionStore sessionStore = this.createSessionStore();
            CallContext ctx = new CallContext(context, sessionStore);
            SAML2Credentials unvalidated = client.getCredentials(ctx).orElse(null);
            credentials = client.validateCredentials(ctx, (Credentials)unvalidated).orElse(null);
            saml2Profile = client.getUserProfile(ctx, (Credentials)credentials).orElse(null);
            ValueGenerator stateGenerator = client.getStateGenerator();
            Optional<String> mayRelayState = context.getRequestParameter("RelayState");
            if (stateGenerator instanceof RelayStateMapper) {
                RelayStateMapper f = (RelayStateMapper)stateGenerator;
                if (mayRelayState.isPresent()) {
                    mayRelayState = f.map((String)mayRelayState.get());
                }
            }
            mayRelayState.ifPresent(relayState -> {
                this.redirectUrl = (String)RefererStateGenerator.CACHE.getIfPresent(relayState);
            });
            if (this.redirectUrl == null) {
                this.redirectUrl = Jenkins.get().getRootUrl();
            }
            client.destroy();
        }
        catch (HttpAction | SAMLException e) {
            throw new BadCredentialsException(e.getMessage(), e);
        }
        if (saml2Profile == null) {
            String msg = "Could not find user profile for SAML credentials: " + String.valueOf(credentials);
            LOG.severe(msg);
            throw new BadCredentialsException(msg);
        }
        LOG.finer(saml2Profile.toString());
        return saml2Profile;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }
}

