/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.model.User;
import hudson.security.GroupDetails;
import java.util.HashSet;
import java.util.Set;
import jenkins.security.LastGrantedAuthoritiesProperty;

public class SamlGroupDetails
extends GroupDetails {
    private final String name;
    private final Set<String> members = new HashSet<String>();

    public SamlGroupDetails(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Set<String> getMembers() {
        if (this.members.isEmpty()) {
            User.getAll().forEach(u -> {
                LastGrantedAuthoritiesProperty prop = (LastGrantedAuthoritiesProperty)u.getProperty(LastGrantedAuthoritiesProperty.class);
                if (this.hasGroupOnAuthorities(prop)) {
                    this.members.add(u.getId());
                }
            });
        }
        return this.members;
    }

    private boolean hasGroupOnAuthorities(LastGrantedAuthoritiesProperty prop) {
        if (prop != null) {
            return prop.getAuthorities2().stream().anyMatch(a -> this.name.equals(a.getAuthority()));
        }
        return false;
    }
}

