/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.saml;

import hudson.Extension;
import hudson.security.csrf.CrumbExclusion;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.saml.SamlSecurityRealm;

@Extension
public class SamlCrumbExclusion
extends CrumbExclusion {
    private static final Logger LOG = Logger.getLogger(SamlCrumbExclusion.class.getName());

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Jenkins j = Jenkins.get();
        if (j.getSecurityRealm() instanceof SamlSecurityRealm && SamlCrumbExclusion.shouldExclude(request.getPathInfo())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private static boolean shouldExclude(String pathInfo) {
        if (pathInfo == null) {
            LOG.fine("SamlCrumbExclusion.shouldExclude empty");
            return false;
        }
        if (pathInfo.startsWith("/securityRealm/finishLogin")) {
            LOG.fine("SamlCrumbExclusion.shouldExclude excluding '" + pathInfo + "'");
            return true;
        }
        LOG.finer("SamlCrumbExclusion.shouldExclude keeping '" + pathInfo + "'");
        return false;
    }
}

