// CHECKSTYLE:OFF

package org.jenkins.ci.plugins.saferestart;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SafeRestartManagementLink.description}: {@code Restart once
     * no jobs are running.}.
     * 
     * @return
     *     {@code Restart once no jobs are running.}
     */
    public static String SafeRestartManagementLink_description() {
        return holder.format("SafeRestartManagementLink.description");
    }

    /**
     * Key {@code SafeRestartManagementLink.description}: {@code Restart once
     * no jobs are running.}.
     * 
     * @return
     *     {@code Restart once no jobs are running.}
     */
    public static Localizable _SafeRestartManagementLink_description() {
        return new Localizable(holder, "SafeRestartManagementLink.description");
    }

    /**
     * Key {@code SafeRestartRootAction.displayName}: {@code Restart Safely}.
     * 
     * @return
     *     {@code Restart Safely}
     */
    public static String SafeRestartRootAction_displayName() {
        return holder.format("SafeRestartRootAction.displayName");
    }

    /**
     * Key {@code SafeRestartRootAction.displayName}: {@code Restart Safely}.
     * 
     * @return
     *     {@code Restart Safely}
     */
    public static Localizable _SafeRestartRootAction_displayName() {
        return new Localizable(holder, "SafeRestartRootAction.displayName");
    }

    /**
     * Key {@code SafeRestartManagementLink.displayName}: {@code Restart
     * Safely}.
     * 
     * @return
     *     {@code Restart Safely}
     */
    public static String SafeRestartManagementLink_displayName() {
        return holder.format("SafeRestartManagementLink.displayName");
    }

    /**
     * Key {@code SafeRestartManagementLink.displayName}: {@code Restart
     * Safely}.
     * 
     * @return
     *     {@code Restart Safely}
     */
    public static Localizable _SafeRestartManagementLink_displayName() {
        return new Localizable(holder, "SafeRestartManagementLink.displayName");
    }

}
