/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.s3;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.model.UploadRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.NamedThreadFactory;

public final class Uploads {
    private static final Logger LOGGER = Logger.getLogger(Uploads.class.getName());
    public static final int MULTIPART_UPLOAD_THRESHOLD = 0x1000000;
    private static volatile transient Uploads instance;
    private final transient Map<FilePath, Upload> startedUploads = new ConcurrentHashMap<FilePath, Upload>();
    private final ExecutorService executors;
    private final transient Map<FilePath, InputStream> openedStreams;

    private Uploads() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(Executors.defaultThreadFactory(), Uploads.class.getName()));
        pool.allowCoreThreadTimeOut(true);
        this.executors = pool;
        this.openedStreams = new ConcurrentHashMap<FilePath, InputStream>();
    }

    public Upload startUploading(S3TransferManager manager, FilePath file, InputStream inputStream, String bucketName, String objectName, Metadata metadata, TransferListener listener) {
        UploadRequest.Builder request = UploadRequest.builder();
        request.putObjectRequest(metadata.builder.andThen(b -> b.bucket(bucketName).key(objectName).metadata(metadata.metadata)));
        request.requestBody(AsyncRequestBody.fromInputStream((InputStream)inputStream, (Long)metadata.getContentLength(), (ExecutorService)this.executors));
        if (listener != null) {
            request.addTransferListener(listener);
        }
        Upload upload = manager.upload(request.build());
        this.startedUploads.put(file, upload);
        this.openedStreams.put(file, inputStream);
        return upload;
    }

    public void finishUploading(FilePath filePath) throws InterruptedException, IOException {
        Upload upload = this.startedUploads.remove(filePath);
        if (upload == null) {
            LOGGER.info("File: " + filePath.getName() + " already was uploaded");
            return;
        }
        try {
            upload.completionFuture().get(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            upload.completionFuture().cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            throw new IOException("Upload failed for: " + filePath.getName(), e.getCause());
        }
        catch (TimeoutException e) {
            upload.completionFuture().cancel(true);
            throw new IOException("Upload timed out for: " + filePath.getName(), e);
        }
        finally {
            this.closeStream(filePath);
        }
    }

    public void cleanup(FilePath filePath) {
        this.startedUploads.remove(filePath);
        this.closeStream(filePath);
    }

    private void closeStream(FilePath filePath) {
        try {
            InputStream stream = this.openedStreams.remove(filePath);
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Failed to close stream for file:" + String.valueOf(filePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uploads getInstance() {
        if (instance != null) return instance;
        Class<Uploads> clazz = Uploads.class;
        synchronized (Uploads.class) {
            if (instance != null) return instance;
            instance = new Uploads();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static class Metadata {
        private Consumer<PutObjectRequest.Builder> builder;
        private final Map<String, String> metadata;
        private long contentLength;

        public Metadata(Consumer<PutObjectRequest.Builder> builder, Map<String, String> metadata) {
            this.builder = builder;
            this.metadata = metadata != null ? metadata : new HashMap();
        }

        public Metadata(Consumer<PutObjectRequest.Builder> builder) {
            this(builder, new HashMap<String, String>());
        }

        public void putMetadata(String key, String value) {
            this.metadata.put(key, value);
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        public void andThen(Consumer<PutObjectRequest.Builder> addition) {
            this.builder = this.builder.andThen(addition);
        }
    }
}

