/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class RoleStrategyConfig
extends ManagementLink {
    @NonNull
    public static RoleStrategyConfig get() {
        return (RoleStrategyConfig)((Object)ExtensionList.lookupSingleton(RoleStrategyConfig.class));
    }

    public static int getMaxRows() {
        return SystemProperties.getInteger((String)(RoleStrategyConfig.class.getName() + ".MAX_ROWS"), (Integer)30);
    }

    public String getIconFileName() {
        if (Jenkins.get().getAuthorizationStrategy() instanceof RoleBasedAuthorizationStrategy) {
            return "symbol-lock-closed-outline plugin-ionicons-api";
        }
        return null;
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    public String getUrlName() {
        return "role-strategy";
    }

    @NonNull
    public String getCategoryName() {
        return "SECURITY";
    }

    public String getDisplayName() {
        return Messages.RoleBasedAuthorizationStrategy_ManageAndAssign();
    }

    public String getAssignRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Assign();
    }

    public String getManageRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Manage();
    }

    public String getDescription() {
        return Messages.RoleBasedAuthorizationStrategy_Description();
    }

    @CheckForNull
    public AuthorizationStrategy getStrategy() {
        AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
        if (strategy instanceof RoleBasedAuthorizationStrategy) {
            return strategy;
        }
        return null;
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRolesSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkAnyPermission(RoleBasedAuthorizationStrategy.ADMINISTER_AND_SOME_ROLES_ADMIN);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doRolesSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doTemplatesSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(RoleBasedAuthorizationStrategy.ITEM_ROLES_ADMIN);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doTemplatesSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        JSONObject rolesMapping;
        Jenkins.get().checkAnyPermission(RoleBasedAuthorizationStrategy.ADMINISTER_AND_SOME_ROLES_ADMIN);
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        if (json.has("submit")) {
            String rm = json.getString("rolesMapping");
            rolesMapping = JSONObject.fromObject((Object)rm);
        } else {
            rolesMapping = json.getJSONObject("rolesMapping");
        }
        if (rolesMapping.has("agentRoles")) {
            rolesMapping.put("slaveRoles", (Object)rolesMapping.getJSONArray("agentRoles"));
        }
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doAssignSubmit(rolesMapping);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    public ExtensionList<RoleMacroExtension> getRoleMacroExtensions() {
        return RoleMacroExtension.all();
    }

    public final RoleType getGlobalRoleType() {
        return RoleType.Global;
    }

    public final RoleType getProjectRoleType() {
        return RoleType.Project;
    }

    public final RoleType getSlaveRoleType() {
        return RoleType.Slave;
    }
}

