/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rocketchatnotifier;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.rocketchatnotifier.RocketClient;
import jenkins.plugins.rocketchatnotifier.RocketClientImpl;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatClient;
import jenkins.plugins.rocketchatnotifier.rocket.RocketChatClientImpl;
import jenkins.plugins.rocketchatnotifier.rocket.errorhandling.RocketClientException;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class RocketClientWebhookImpl
implements RocketClient {
    private static final Logger LOGGER = Logger.getLogger(RocketClientImpl.class.getName());
    private RocketChatClient client;
    private String channel;

    public RocketClientWebhookImpl(String serverUrl, boolean trustSSL, String token, String webhookTokenCredentialId, String channel) throws RocketClientException {
        this.client = new RocketChatClientImpl(serverUrl, trustSSL, this.getTokenToUse(webhookTokenCredentialId, token));
        this.channel = channel;
    }

    @Override
    public boolean publish(String message, List<Map<String, Object>> attachments) {
        try {
            LOGGER.fine("Starting sending message to webhook");
            this.client.send(this.channel, message);
            return true;
        }
        catch (RocketClientException e) {
            LOGGER.log(Level.SEVERE, "I/O error error during publishing message", e);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown error error during publishing message", e);
            return false;
        }
    }

    @Override
    public boolean publish(String message, String emoji, String avatar, List<Map<String, Object>> attachments) {
        try {
            LOGGER.fine("Starting sending message to webhook");
            this.client.send(this.channel, message, emoji, avatar, attachments);
            return true;
        }
        catch (RocketClientException e) {
            LOGGER.log(Level.SEVERE, "I/O error error during publishing message", e);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unknown error error during publishing message", e);
            return false;
        }
    }

    @Override
    public void validate() throws CertificateException, RocketClientException {
        this.client.send("", "Test message from Jenkins via Webhook");
    }

    private String getTokenToUse(String webhookTokenCredentialId, String tokenString) {
        StringCredentials credentials;
        if (!StringUtils.isEmpty((String)webhookTokenCredentialId) && (credentials = this.lookupCredentials(webhookTokenCredentialId)) != null) {
            LOGGER.fine("Using Integration Token Credential ID.");
            return credentials.getSecret().getPlainText();
        }
        LOGGER.fine("Using Integration Token.");
        return tokenString;
    }

    private StringCredentials lookupCredentials(String credentialId) {
        List credentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.getInstanceOrNull(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        CredentialsMatcher matcher = CredentialsMatchers.withId((String)credentialId);
        return (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)credentials, (CredentialsMatcher)matcher);
    }
}

