// CHECKSTYLE:OFF

package jenkins.plugins.rocketchatnotifier;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code NotificationFailedWithException}: {@code RocketChat
     * notification failed with exception: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code RocketChat notification failed with exception: {0}}
     */
    public static String NotificationFailedWithException(Object arg0) {
        return holder.format("NotificationFailedWithException", arg0);
    }

    /**
     * Key {@code NotificationFailedWithException}: {@code RocketChat
     * notification failed with exception: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code RocketChat notification failed with exception: {0}}
     */
    public static Localizable _NotificationFailedWithException(Object arg0) {
        return new Localizable(holder, "NotificationFailedWithException", arg0);
    }

    /**
     * Key {@code NotificationFailed}: {@code RocketChat notification failed.
     * See Jenkins logs for details.}.
     * 
     * @return
     *     {@code RocketChat notification failed. See Jenkins logs for details.}
     */
    public static String NotificationFailed() {
        return holder.format("NotificationFailed");
    }

    /**
     * Key {@code NotificationFailed}: {@code RocketChat notification failed.
     * See Jenkins logs for details.}.
     * 
     * @return
     *     {@code RocketChat notification failed. See Jenkins logs for details.}
     */
    public static Localizable _NotificationFailed() {
        return new Localizable(holder, "NotificationFailed");
    }

    /**
     * Key {@code RocketSendStepDisplayName}: {@code Send RocketChat
     * Message}.
     * 
     * @return
     *     {@code Send RocketChat Message}
     */
    public static String RocketSendStepDisplayName() {
        return holder.format("RocketSendStepDisplayName");
    }

    /**
     * Key {@code RocketSendStepDisplayName}: {@code Send RocketChat
     * Message}.
     * 
     * @return
     *     {@code Send RocketChat Message}
     */
    public static Localizable _RocketSendStepDisplayName() {
        return new Localizable(holder, "RocketSendStepDisplayName");
    }

    /**
     * Key {@code RocketSendStepConfig}: {@code RocketChat Send Pipeline step
     * configured with server: {0}, trustSSL: {1}, channel: {2} and message:
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code RocketChat Send Pipeline step configured with server: {0},
     *     trustSSL: {1}, channel: {2} and message: {3}}
     */
    public static String RocketSendStepConfig(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("RocketSendStepConfig", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code RocketSendStepConfig}: {@code RocketChat Send Pipeline step
     * configured with server: {0}, trustSSL: {1}, channel: {2} and message:
     * {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code RocketChat Send Pipeline step configured with server: {0},
     *     trustSSL: {1}, channel: {2} and message: {3}}
     */
    public static Localizable _RocketSendStepConfig(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "RocketSendStepConfig", arg0, arg1, arg2, arg3);
    }

}
