/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.graph;

import hudson.plugins.robot.Messages;
import hudson.plugins.robot.graph.RobotBuildLabel;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.model.RobotTestObject;
import hudson.util.DataSetBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class RobotGraphHelper {
    private static int SECONDSCALE = 1000;
    private static int MINUTESCALE = 60000;
    private static int HOURSCALE = 3600000;

    public static RobotGraph createTestResultsGraphForTestObject(RobotTestObject rootObject, boolean significantData, boolean binarydata, boolean hd, boolean failedOnly, String labelFormat, int maxBuildsToShow) {
        ArrayList<Number> values = new ArrayList<Number>();
        ArrayList<String> rows = new ArrayList<String>();
        ArrayList<RobotBuildLabel> columns = new ArrayList<RobotBuildLabel>();
        double lowerbound = 0.0;
        double upperbound = 0.0;
        int buildsLeftToShow = maxBuildsToShow > 0 ? maxBuildsToShow : -1;
        for (RobotTestObject testObject = rootObject; testObject != null && buildsLeftToShow != 0; testObject = testObject.getPreviousResult(), --buildsLeftToShow) {
            int compareLowerBoundTo;
            Integer failed = testObject.getFailed();
            Integer passed = 0;
            Integer skipped = 0;
            if (failedOnly) {
                compareLowerBoundTo = failed;
            } else {
                passed = testObject.getPassed();
                skipped = testObject.getSkipped();
                compareLowerBoundTo = passed;
            }
            if (significantData) {
                if (lowerbound == 0.0 || lowerbound > (double)compareLowerBoundTo) {
                    lowerbound = compareLowerBoundTo;
                }
                if (upperbound < (double)(failed + passed)) {
                    upperbound = failed + passed;
                }
            }
            RobotBuildLabel label = new RobotBuildLabel(testObject, labelFormat);
            values.add(passed);
            rows.add(Messages.robot_trendgraph_passed());
            columns.add(label);
            values.add(failed);
            rows.add(Messages.robot_trendgraph_failed());
            columns.add(label);
            values.add(skipped);
            rows.add(Messages.robot_trendgraph_skipped());
            columns.add(label);
        }
        if (significantData) {
            lowerbound = Math.max(0.0, lowerbound - (1.0 + upperbound - lowerbound) * 0.05);
            upperbound += (1.0 + upperbound - lowerbound) * 0.05;
        }
        int graphScale = hd ? 3 : 1;
        return RobotGraph.getRobotGraph(rootObject.getOwner(), RobotGraphHelper.createSortedDataset(values, rows, columns), Messages.robot_trendgraph_testcases(), Messages.robot_trendgraph_builds(), graphScale, false, binarydata, lowerbound, upperbound, Color.orange, Color.green, Color.red);
    }

    public static RobotGraph createDurationGraphForTestObject(RobotTestObject rootObject, boolean hd, int maxBuildsToShow, String labelFormat, boolean preview) {
        DataSetBuilder builder = new DataSetBuilder();
        int scale = 1;
        int buildsLeftToShow = maxBuildsToShow > 0 ? maxBuildsToShow : -1;
        ArrayList<RobotBuildLabel> labels = new ArrayList<RobotBuildLabel>();
        ArrayList<Long> durations = new ArrayList<Long>();
        for (RobotTestObject testObject = rootObject; testObject != null && buildsLeftToShow != 0; testObject = testObject.getPreviousResult(), --buildsLeftToShow) {
            scale = RobotGraphHelper.getTimeScaleFactor(testObject.getDuration(), scale);
            labels.add(new RobotBuildLabel(testObject, labelFormat));
            durations.add(testObject.getDuration());
        }
        for (int i = 0; i < labels.size(); ++i) {
            builder.add((Number)((double)((Long)durations.get(i)).longValue() / (double)scale), (Comparable)((Object)"Duration"), (Comparable)((RobotBuildLabel)labels.get(i)));
        }
        double graphScale = hd ? 3.0 : 1.0;
        return RobotGraph.getRobotGraph(rootObject.getOwner(), builder.build(), "Duration (" + RobotGraphHelper.getTimeScaleString(scale) + ")", Messages.robot_trendgraph_builds(), graphScale, preview, false, 0.0, 0.0, Color.cyan);
    }

    private static CategoryDataset createSortedDataset(List<Number> values, List<String> rows, List<RobotBuildLabel> columns) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        TreeSet<String> rowSet = new TreeSet<String>(rows);
        TreeSet<RobotBuildLabel> colSet = new TreeSet<RobotBuildLabel>(columns);
        Comparable[] _rows = rowSet.toArray(new Comparable[rowSet.size()]);
        Comparable[] _cols = colSet.toArray(new Comparable[colSet.size()]);
        for (int i = _rows.length - 1; i >= 0; --i) {
            dataset.setValue(null, _rows[i], _cols[0]);
        }
        for (Comparable c : _cols) {
            dataset.setValue(null, _rows[0], c);
        }
        for (int i = 0; i < values.size(); ++i) {
            dataset.addValue(values.get(i), (Comparable)((Object)rows.get(i)), (Comparable)columns.get(i));
        }
        return dataset;
    }

    private static int getTimeScaleFactor(float duration, int originalScale) {
        int scale = originalScale;
        if (duration > (float)HOURSCALE) {
            scale = HOURSCALE;
        } else if (duration > (float)MINUTESCALE) {
            scale = MINUTESCALE;
        } else if (duration > (float)SECONDSCALE) {
            scale = SECONDSCALE;
        }
        return scale;
    }

    private static String getTimeScaleString(int scale) {
        if (scale == SECONDSCALE) {
            return "s";
        }
        if (scale == MINUTESCALE) {
            return "min";
        }
        if (scale == HOURSCALE) {
            return "h";
        }
        return "ms";
    }
}

