/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.blueocean;

import hudson.Extension;
import hudson.model.Run;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.model.RobotCaseResult;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import java.util.stream.Collectors;

public class BlueRobotTestResult
extends BlueTestResult {
    protected final RobotCaseResult result;

    public BlueRobotTestResult(RobotCaseResult result, Link parent) {
        super(parent);
        this.result = result;
    }

    public String getName() {
        return this.result.getDisplayName();
    }

    public BlueTestResult.Status getStatus() {
        if (this.result.isPassed()) {
            return BlueTestResult.Status.PASSED;
        }
        if (this.result.isSkipped()) {
            return BlueTestResult.Status.SKIPPED;
        }
        return BlueTestResult.Status.FAILED;
    }

    public BlueTestResult.State getTestState() {
        return BlueTestResult.State.UNKNOWN;
    }

    public float getDuration() {
        return (float)this.result.getDuration() / 1000.0f;
    }

    public String getErrorStackTrace() {
        return this.result.getStackTrace();
    }

    public String getErrorDetails() {
        return this.result.getErrorMsg() == null ? "" : this.result.getErrorMsg();
    }

    public String getUniqueId() {
        return this.result.getId();
    }

    public int getAge() {
        return this.result.getAge();
    }

    public String getStdErr() {
        return "";
    }

    public String getStdOut() {
        return "";
    }

    public boolean hasStdLog() {
        return false;
    }

    @Extension(optional=true)
    public static class FactoryImpl
    extends BlueTestResultFactory {
        public BlueTestResultFactory.Result getBlueTestResults(Run<?, ?> run, Reachable parent) {
            RobotBuildAction action = (RobotBuildAction)run.getAction(RobotBuildAction.class);
            if (action == null) {
                return BlueTestResultFactory.Result.notFound();
            }
            return BlueTestResultFactory.Result.of((Iterable)action.getAllTests().stream().map(t -> new BlueRobotTestResult((RobotCaseResult)t, parent.getLink())).collect(Collectors.toList()));
        }
    }
}

