/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.robot.AggregatedRobotAction;
import hudson.plugins.robot.Messages;
import hudson.plugins.robot.RobotBuildAction;
import hudson.util.ChartUtil;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Calendar;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class RobotProjectAction
implements Action {
    private Job<?, ?> project;

    public RobotProjectAction(Job<?, ?> project) {
        this.project = project;
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public boolean isDisplayGraph() {
        return this.getLastBuildAction() != null;
    }

    public Action getLastBuildAction() {
        Run<?, ?> lastBuild = this.getLastBuildWithRobot();
        if (lastBuild != null) {
            RobotBuildAction action = (RobotBuildAction)lastBuild.getAction(RobotBuildAction.class);
            if (action == null) {
                return lastBuild.getAction(AggregatedRobotAction.class);
            }
            return action;
        }
        return null;
    }

    public void doGraph(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.project.getLastCompletedBuild().getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        Run<?, ?> lastBuild = this.getLastBuildWithRobot();
        rsp.sendRedirect2("../" + lastBuild.getNumber() + "/" + this.getUrlName() + "/graph?zoomSignificant=" + Boolean.valueOf(req.getParameter("zoomSignificant")) + "&hd=" + Boolean.valueOf(req.getParameter("hd")) + "&failedOnly=" + Boolean.valueOf(req.getParameter("failedOnly")) + "&maxBuildsToShow=" + Integer.valueOf(req.getParameter("maxBuildsToShow")));
    }

    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Run<?, ?> lastBuild = this.getLastBuildWithRobot();
        if (lastBuild == null) {
            rsp.sendRedirect2("nodata");
        } else {
            int buildNumber = lastBuild.getNumber();
            rsp.sendRedirect2("../" + buildNumber + "/" + this.getUrlName());
        }
    }

    private Run<?, ?> getLastBuildWithRobot() {
        Run lastBuild;
        for (lastBuild = this.project.getLastBuild(); lastBuild != null && lastBuild.getAction(RobotBuildAction.class) == null && lastBuild.getAction(AggregatedRobotAction.class) == null; lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public String getIconFileName() {
        return "/plugin/robot/robot.png";
    }

    public String getDisplayName() {
        return Messages.robot_sidebar_link();
    }

    public String getUrlName() {
        return "robot";
    }
}

