/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.repo;

import hudson.Util;
import hudson.plugins.repo.ProjectState;
import hudson.scm.SCMRevisionState;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class RevisionState
extends SCMRevisionState
implements Serializable {
    private final String manifest;
    private final Map<String, ProjectState> projects;
    private final String url;
    private final String branch;
    private final String file;
    private static Logger debug = Logger.getLogger("hudson.plugins.repo.RevisionState");

    RevisionState(String manifest, String manifestRevision, String url, String branch, String file, @Nullable PrintStream logger) {
        block7: {
            this.projects = new TreeMap<String, ProjectState>();
            this.manifest = manifest;
            this.url = url;
            this.branch = branch;
            this.file = file;
            try {
                Document doc = XMLUtils.parse((Reader)new StringReader(manifest));
                if (!doc.getDocumentElement().getNodeName().equals("manifest")) {
                    if (logger != null) {
                        logger.println("Error - malformed manifest");
                    }
                    return;
                }
                NodeList projectNodes = doc.getElementsByTagName("project");
                int numProjects = projectNodes.getLength();
                for (int i = 0; i < numProjects; ++i) {
                    Element projectElement = (Element)projectNodes.item(i);
                    String path = Util.fixEmptyAndTrim((String)projectElement.getAttribute("path"));
                    String serverPath = Util.fixEmptyAndTrim((String)projectElement.getAttribute("name"));
                    String revision = Util.fixEmptyAndTrim((String)projectElement.getAttribute("revision"));
                    if (path == null) {
                        path = serverPath;
                    }
                    if (path == null || serverPath == null || revision == null) continue;
                    this.projects.put(path, ProjectState.constructCachedInstance(path, serverPath, revision));
                    if (logger == null) continue;
                    logger.println("Added a project: " + path + " at revision: " + revision);
                }
                String manifestP = ".repo/manifests.git";
                this.projects.put(".repo/manifests.git", ProjectState.constructCachedInstance(".repo/manifests.git", ".repo/manifests.git", manifestRevision));
                if (logger != null) {
                    logger.println("Manifest at revision: " + manifestRevision);
                }
            }
            catch (Exception e) {
                if (logger == null) break block7;
                logger.println(e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RevisionState) {
            RevisionState other = (RevisionState)obj;
            if (this.branch == null) {
                if (other.branch != null) {
                    return false;
                }
                return this.projects.equals(other.projects);
            }
            return this.branch.equals(other.branch) && this.projects.equals(other.projects);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (this.branch != null ? this.branch.hashCode() : 0) ^ (this.url != null ? this.url.hashCode() : 0) ^ (this.file != null ? this.file.hashCode() : 0) ^ (this.manifest != null ? this.manifest.hashCode() : 0) ^ this.projects.hashCode();
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getFile() {
        return this.file;
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getRevision(String path) {
        ProjectState project = this.projects.get(path);
        return project == null ? null : project.getRevision();
    }

    List<ProjectState> whatChanged(@Nullable RevisionState previousState) {
        ArrayList<ProjectState> changes = new ArrayList<ProjectState>();
        if (previousState == null) {
            debug.log(Level.FINE, "Everything is new");
            return null;
        }
        HashMap<String, ProjectState> previousStateCopy = new HashMap<String, ProjectState>(previousState.projects);
        for (Map.Entry<String, ProjectState> entry : this.projects.entrySet()) {
            ProjectState status = previousStateCopy.get(entry.getKey());
            if (status == null) {
                ProjectState newProject = entry.getValue();
                debug.log(Level.FINE, "New project: {0}", entry.getKey());
                changes.add(ProjectState.constructCachedInstance(newProject.getPath(), newProject.getServerPath(), null));
            } else if (!status.equals(entry.getValue())) {
                changes.add(previousStateCopy.get(entry.getKey()));
            }
            previousStateCopy.remove(entry.getKey());
        }
        changes.addAll(previousStateCopy.values());
        return changes;
    }
}

