/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.publish_over.FileFinderResult;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class FileFinder
extends MasterToSlaveFileCallable<FileFinderResult> {
    public static final String DEFAULT_PATTERN_SEPARATOR = "[, ]+";
    private static final long serialVersionUID = 1L;
    private final String includes;
    private final String excludes;
    private final boolean defaultExcludes;
    private final boolean findEmptyDirectories;
    private final String patternSeparatorRegex;

    public FileFinder(String includes, String excludes, boolean defaultExcludes, boolean findEmptyDirectories, String patternSeparatorRegex) {
        this.includes = includes;
        this.excludes = excludes;
        this.defaultExcludes = defaultExcludes;
        this.findEmptyDirectories = findEmptyDirectories;
        this.patternSeparatorRegex = patternSeparatorRegex == null ? DEFAULT_PATTERN_SEPARATOR : patternSeparatorRegex;
    }

    public FileFinderResult invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
        DirectoryScanner scanner = FileFinder.createDirectoryScanner(file, this.includes, this.excludes, this.defaultExcludes, this.patternSeparatorRegex);
        String[] includedFiles = scanner.getIncludedFiles();
        FilePath[] files = FileFinder.toFilePathArray(file, includedFiles);
        FilePath[] dirs = new FilePath[]{};
        if (this.findEmptyDirectories) {
            String[] allDirs = scanner.getIncludedDirectories();
            String[] onlyLeaf = FileFinder.reduce(allDirs, allDirs);
            dirs = FileFinder.toFilePathArray(file, FileFinder.reduce(onlyLeaf, includedFiles));
        }
        return new FileFinderResult(files, dirs);
    }

    static DirectoryScanner createDirectoryScanner(File dir, String includes, String excludes, boolean defaultExcludes, String patternSeparatorRegex) throws IOException {
        int i;
        FileSet fs = new FileSet();
        fs.setDir(dir);
        fs.setProject(new Project());
        if (includes != null) {
            String[] includePatterns = includes.split(patternSeparatorRegex);
            for (i = 0; i < includePatterns.length; ++i) {
                if ("".equals(includePatterns[i])) continue;
                fs.createInclude().setName(includePatterns[i]);
            }
        }
        if (excludes != null) {
            String[] excludePatterns = excludes.split(patternSeparatorRegex);
            for (i = 0; i < excludePatterns.length; ++i) {
                if ("".equals(excludePatterns[i])) continue;
                fs.createExclude().setName(excludePatterns[i]);
            }
        }
        fs.setDefaultexcludes(defaultExcludes);
        return fs.getDirectoryScanner();
    }

    static String[] reduce(String[] directories, String[] paths) {
        HashSet<String> result = new HashSet<String>(Arrays.asList(directories));
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>(Arrays.asList(paths));
        result.remove("");
        pathSet.remove("");
        block0: for (String dir : directories) {
            for (String potential : pathSet) {
                if (!potential.startsWith(dir + File.separator)) continue;
                result.remove(dir);
                pathSet.remove(dir);
                continue block0;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static FilePath[] toFilePathArray(File file, String[] includedFiles) {
        FilePath[] filePaths = new FilePath[includedFiles.length];
        for (int i = 0; i < filePaths.length; ++i) {
            filePaths[i] = new FilePath(new File(file, includedFiles[i]));
        }
        return filePaths;
    }
}

