/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.FilePath;
import hudson.model.Result;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.publish_over.BPBuildEnv;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPCallablePublisher;
import jenkins.plugins.publish_over.BPHostConfiguration;
import jenkins.plugins.publish_over.BPHostConfigurationAccess;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.Messages;
import jenkins.plugins.publish_over.ParamPublish;
import jenkins.plugins.publish_over.PubSelector;
import jenkins.plugins.publish_over.SelectAllPubSelector;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class BPInstanceConfig<PUBLISHER extends BapPublisher>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BPInstanceConfig.class.getName());
    public static final String DEFAULT_MASTER_NODE_NAME = "master";
    private ArrayList<PUBLISHER> publishers;
    private boolean continueOnError;
    private boolean failOnError;
    private boolean alwaysPublishFromMaster;
    private String masterNodeName;
    private BPHostConfigurationAccess hostConfigurationAccess;
    private ParamPublish paramPublish;

    public BPInstanceConfig() {
    }

    public BPInstanceConfig(ArrayList<PUBLISHER> publishers, boolean continueOnError, boolean failOnError, boolean alwaysPublishFromMaster, String masterNodeName, ParamPublish paramPublish) {
        this.setPublishers(publishers);
        this.continueOnError = continueOnError;
        this.failOnError = failOnError;
        this.alwaysPublishFromMaster = alwaysPublishFromMaster;
        this.masterNodeName = masterNodeName;
        this.paramPublish = paramPublish;
    }

    public final ArrayList<PUBLISHER> getPublishers() {
        return this.publishers;
    }

    public final void setPublishers(ArrayList<PUBLISHER> publishers) {
        this.publishers = publishers == null ? new ArrayList() : publishers;
    }

    public final boolean isContinueOnError() {
        return this.continueOnError;
    }

    public final void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public final boolean isFailOnError() {
        return this.failOnError;
    }

    public final void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public final boolean isAlwaysPublishFromMaster() {
        return this.alwaysPublishFromMaster;
    }

    public final void setAlwaysPublishFromMaster(boolean alwaysPublishFromMaster) {
        this.alwaysPublishFromMaster = alwaysPublishFromMaster;
    }

    public final String getMasterNodeName() {
        return this.masterNodeName;
    }

    public final void setMasterNodeName(String masterNodeName) {
        this.masterNodeName = masterNodeName;
    }

    public final void setHostConfigurationAccess(BPHostConfigurationAccess hostConfigurationAccess) {
        this.hostConfigurationAccess = hostConfigurationAccess;
    }

    public ParamPublish getParamPublish() {
        return this.paramPublish;
    }

    public void setParamPublish(ParamPublish paramPublish) {
        this.paramPublish = paramPublish;
    }

    public BPHostConfiguration getConfiguration(String configName) {
        BPHostConfiguration config = this.hostConfigurationAccess.getConfiguration(configName);
        if (config == null) {
            throw new BapPublisherException(Messages.exception_failedToFindConfiguration(configName));
        }
        return config;
    }

    private void fixMasterNodeNameInEnv(BPBuildEnv buildEnv) {
        if (buildEnv != null) {
            buildEnv.fixMasterNodeName(this.masterNodeName);
        }
    }

    private void fixMasterNodeName(BPBuildInfo buildInfo) {
        this.fixMasterNodeNameInEnv(buildInfo.getCurrentBuildEnv());
        this.fixMasterNodeNameInEnv(buildInfo.getTargetBuildEnv());
    }

    public final Result perform(BPBuildInfo buildInfo) {
        Result onError;
        Result toReturn = Result.SUCCESS;
        Result result = onError = this.failOnError ? Result.FAILURE : Result.UNSTABLE;
        if (this.masterNodeName != null) {
            this.fixMasterNodeName(buildInfo);
        }
        PubSelector selector = null;
        try {
            selector = this.createSelector(buildInfo);
        }
        catch (BapPublisherException bpe) {
            LOGGER.log(Level.WARNING, bpe.getLocalizedMessage(), bpe);
            buildInfo.getListener().error(bpe.getLocalizedMessage());
            return onError;
        }
        for (BapPublisher publisher : this.publishers) {
            publisher.setEffectiveEnvironmentInBuildInfo(buildInfo);
            if (!selector.selected(publisher)) continue;
            try {
                BPHostConfiguration hostConfig = this.getConfiguration(publisher.getConfigName());
                BPCallablePublisher callablePublisher = new BPCallablePublisher(publisher, hostConfig, buildInfo);
                if (this.alwaysPublishFromMaster) {
                    callablePublisher.invoke(null, null);
                    continue;
                }
                buildInfo.getBaseDirectory().act((FilePath.FileCallable)callablePublisher);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, Messages.log_exceptionInPerform(), e);
                buildInfo.getListener().error(e.getLocalizedMessage());
                if (this.continueOnError) {
                    toReturn = toReturn.combine(onError);
                    continue;
                }
                return onError;
            }
        }
        return toReturn;
    }

    private PubSelector createSelector(BPBuildInfo buildInfo) {
        if (this.paramPublish == null) {
            return SelectAllPubSelector.SELECT_ALL;
        }
        return this.paramPublish.createSelector(buildInfo);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append(this.publishers).append(this.continueOnError).append(this.failOnError).append(this.alwaysPublishFromMaster).append((Object)this.masterNodeName).append((Object)this.paramPublish);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BPInstanceConfig that) {
        return builder.append(this.publishers, that.publishers).append(this.continueOnError, that.continueOnError).append(this.failOnError, that.failOnError).append((Object)this.masterNodeName, (Object)that.masterNodeName).append(this.alwaysPublishFromMaster, that.alwaysPublishFromMaster).append((Object)this.paramPublish, (Object)that.paramPublish);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("publishers", this.publishers).append("continueOnError", this.continueOnError).append("failOnError", this.failOnError).append("masterNodeName", (Object)this.masterNodeName).append("alwaysPublishFromMaster", this.alwaysPublishFromMaster).append("paramPublish", (Object)this.paramPublish);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BPInstanceConfig)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }
}

