/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.publish_over;

import hudson.Util;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import jenkins.plugins.publish_over.BPBuildInfo;
import jenkins.plugins.publish_over.BPClient;
import jenkins.plugins.publish_over.BapPublisher;
import jenkins.plugins.publish_over.BapPublisherException;
import jenkins.plugins.publish_over.Messages;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class BPHostConfiguration<CLIENT extends BPClient, COMMON_CONFIG>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String hostname;
    private String username;
    private String password;
    private Secret secretPassword;
    private String remoteRootDir;
    private int port;
    private COMMON_CONFIG commonConfig;

    public BPHostConfiguration() {
    }

    public BPHostConfiguration(String name, String hostname, String username, String password, String remoteRootDir, int port) {
        this.name = name;
        this.hostname = hostname;
        this.username = username;
        this.secretPassword = Secret.fromString((String)password);
        this.remoteRootDir = remoteRootDir;
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostnameTrimmed() {
        return Util.fixEmptyAndTrim((String)this.hostname);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected String getPassword() {
        return Secret.toString((Secret)this.secretPassword);
    }

    public void setPassword(String password) {
        this.secretPassword = Secret.fromString((String)password);
    }

    public String getEncryptedPassword() {
        return this.secretPassword == null ? null : this.secretPassword.getEncryptedValue();
    }

    public String getRemoteRootDir() {
        return this.remoteRootDir;
    }

    public void setRemoteRootDir(String remoteRootDir) {
        this.remoteRootDir = remoteRootDir;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public COMMON_CONFIG getCommonConfig() {
        return this.commonConfig;
    }

    public void setCommonConfig(COMMON_CONFIG commonConfig) {
        this.commonConfig = commonConfig;
    }

    public CLIENT createClient(BPBuildInfo buildInfo, BapPublisher publisher) {
        return this.createClient(buildInfo);
    }

    public abstract CLIENT createClient(BPBuildInfo var1);

    protected boolean isDirectoryAbsolute(String directory) {
        if (directory == null || directory.length() < 1) {
            return false;
        }
        char first = directory.charAt(0);
        return first == '/' || first == '\\';
    }

    protected void changeToRootDirectory(BPClient client) throws IOException {
        String remoteRootDir = this.getRemoteRootDir();
        if (Util.fixEmptyAndTrim((String)remoteRootDir) != null && !client.changeDirectory(remoteRootDir)) {
            this.exception(client, Messages.exception_cwdRemoteRoot(remoteRootDir));
        }
    }

    protected void exception(BPClient client, String message) {
        BapPublisherException.exception(client, message);
    }

    protected HashCodeBuilder addToHashCode(HashCodeBuilder builder) {
        return builder.append((Object)this.name).append((Object)this.hostname).append((Object)this.username).append((Object)this.secretPassword).append((Object)this.remoteRootDir).append(this.commonConfig).append(this.port);
    }

    protected EqualsBuilder addToEquals(EqualsBuilder builder, BPHostConfiguration that) {
        return builder.append((Object)this.name, (Object)that.name).append((Object)this.hostname, (Object)that.hostname).append((Object)this.username, (Object)that.username).append((Object)this.secretPassword, (Object)that.secretPassword).append((Object)this.remoteRootDir, (Object)that.remoteRootDir).append(this.commonConfig, that.commonConfig).append(this.port, that.port);
    }

    protected ToStringBuilder addToToString(ToStringBuilder builder) {
        return builder.append("name", (Object)this.name).append("hostname", (Object)this.hostname).append("username", (Object)this.username).append("remoteRootDir", (Object)this.remoteRootDir).append("commonConfig", this.commonConfig).append("port", this.port);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.addToEquals(new EqualsBuilder(), (BPHostConfiguration)that).isEquals();
    }

    public int hashCode() {
        return this.addToHashCode(new HashCodeBuilder()).toHashCode();
    }

    public String toString() {
        return this.addToToString(new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE)).toString();
    }

    public Object readResolve() {
        if (this.secretPassword == null) {
            this.secretPassword = Secret.fromString((String)this.password);
        }
        this.password = null;
        return this;
    }
}

