// CHECKSTYLE:OFF

package jenkins.plugins.publish_over;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code console.transferredXFiles}: {@code Transferred {0}
     * file(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transferred {0} file(s)}
     */
    public static String console_transferredXFiles(Object arg0) {
        return holder.format("console.transferredXFiles", arg0);
    }

    /**
     * Key {@code console.transferredXFiles}: {@code Transferred {0}
     * file(s)}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transferred {0} file(s)}
     */
    public static Localizable _console_transferredXFiles(Object arg0) {
        return new Localizable(holder, "console.transferredXFiles", arg0);
    }

    /**
     * Key {@code exception.readFile}: {@code Failed to read file - filename
     * [{0}] (relative to JENKINS_HOME if not absolute). Message: [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read file - filename [{0}] (relative to JENKINS_HOME
     *     if not absolute). Message: [{1}]}
     */
    public static String exception_readFile(Object arg0, Object arg1) {
        return holder.format("exception.readFile", arg0, arg1);
    }

    /**
     * Key {@code exception.readFile}: {@code Failed to read file - filename
     * [{0}] (relative to JENKINS_HOME if not absolute). Message: [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to read file - filename [{0}] (relative to JENKINS_HOME
     *     if not absolute). Message: [{1}]}
     */
    public static Localizable _exception_readFile(Object arg0, Object arg1) {
        return new Localizable(holder, "exception.readFile", arg0, arg1);
    }

    /**
     * Key {@code validator.optionalIP}: {@code Optional. Leave empty or
     * enter an IP address (v4)}.
     * 
     * @return
     *     {@code Optional. Leave empty or enter an IP address (v4)}
     */
    public static String validator_optionalIP() {
        return holder.format("validator.optionalIP");
    }

    /**
     * Key {@code validator.optionalIP}: {@code Optional. Leave empty or
     * enter an IP address (v4)}.
     * 
     * @return
     *     {@code Optional. Leave empty or enter an IP address (v4)}
     */
    public static Localizable _validator_optionalIP() {
        return new Localizable(holder, "validator.optionalIP");
    }

    /**
     * Key {@code console.notPerforming}: {@code Current build result is
     * [{0}], not going to run.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current build result is [{0}], not going to run.}
     */
    public static String console_notPerforming(Object arg0) {
        return holder.format("console.notPerforming", arg0);
    }

    /**
     * Key {@code console.notPerforming}: {@code Current build result is
     * [{0}], not going to run.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current build result is [{0}], not going to run.}
     */
    public static Localizable _console_notPerforming(Object arg0) {
        return new Localizable(holder, "console.notPerforming", arg0);
    }

    /**
     * Key {@code console.publishFromHost.message}: {@code Connecting from
     * host [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting from host [{0}]}
     */
    public static String console_publishFromHost_message(Object arg0) {
        return holder.format("console.publishFromHost.message", arg0);
    }

    /**
     * Key {@code console.publishFromHost.message}: {@code Connecting from
     * host [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting from host [{0}]}
     */
    public static Localizable _console_publishFromHost_message(Object arg0) {
        return new Localizable(holder, "console.publishFromHost.message", arg0);
    }

    /**
     * Key {@code exception.failedToGetHostName}: {@code Failed to get host
     * name}.
     * 
     * @return
     *     {@code Failed to get host name}
     */
    public static String exception_failedToGetHostName() {
        return holder.format("exception.failedToGetHostName");
    }

    /**
     * Key {@code exception.failedToGetHostName}: {@code Failed to get host
     * name}.
     * 
     * @return
     *     {@code Failed to get host name}
     */
    public static Localizable _exception_failedToGetHostName() {
        return new Localizable(holder, "exception.failedToGetHostName");
    }

    /**
     * Key {@code exception.retryDelayInterrupted}: {@code Interrupted whilst
     * sleeping before retry}.
     * 
     * @return
     *     {@code Interrupted whilst sleeping before retry}
     */
    public static String exception_retryDelayInterrupted() {
        return holder.format("exception.retryDelayInterrupted");
    }

    /**
     * Key {@code exception.retryDelayInterrupted}: {@code Interrupted whilst
     * sleeping before retry}.
     * 
     * @return
     *     {@code Interrupted whilst sleeping before retry}
     */
    public static Localizable _exception_retryDelayInterrupted() {
        return new Localizable(holder, "exception.retryDelayInterrupted");
    }

    /**
     * Key {@code log.excludes}: {@code Excludes: configured [{0}], actual
     * [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Excludes: configured [{0}], actual [{1}]}
     */
    public static String log_excludes(Object arg0, Object arg1) {
        return holder.format("log.excludes", arg0, arg1);
    }

    /**
     * Key {@code log.excludes}: {@code Excludes: configured [{0}], actual
     * [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Excludes: configured [{0}], actual [{1}]}
     */
    public static Localizable _log_excludes(Object arg0, Object arg1) {
        return new Localizable(holder, "log.excludes", arg0, arg1);
    }

    /**
     * Key {@code exception.baseDirectoryNotExist}: {@code The base directory
     * does not exist. If this is a promotion, have you "Archived the
     * artifacts"?}.
     * 
     * @return
     *     {@code The base directory does not exist. If this is a promotion, have
     *     you "Archived the artifacts"?}
     */
    public static String exception_baseDirectoryNotExist() {
        return holder.format("exception.baseDirectoryNotExist");
    }

    /**
     * Key {@code exception.baseDirectoryNotExist}: {@code The base directory
     * does not exist. If this is a promotion, have you "Archived the
     * artifacts"?}.
     * 
     * @return
     *     {@code The base directory does not exist. If this is a promotion, have
     *     you "Archived the artifacts"?}
     */
    public static Localizable _exception_baseDirectoryNotExist() {
        return new Localizable(holder, "exception.baseDirectoryNotExist");
    }

    /**
     * Key {@code validator.regularExpression}: {@code Must be a valid Java
     * regular expression - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be a valid Java regular expression - {0}}
     */
    public static String validator_regularExpression(Object arg0) {
        return holder.format("validator.regularExpression", arg0);
    }

    /**
     * Key {@code validator.regularExpression}: {@code Must be a valid Java
     * regular expression - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be a valid Java regular expression - {0}}
     */
    public static Localizable _validator_regularExpression(Object arg0) {
        return new Localizable(holder, "validator.regularExpression", arg0);
    }

    /**
     * Key {@code exception.cwdRemoteRoot}: {@code Failed to change to remote
     * directory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to change to remote directory [{0}]}
     */
    public static String exception_cwdRemoteRoot(Object arg0) {
        return holder.format("exception.cwdRemoteRoot", arg0);
    }

    /**
     * Key {@code exception.cwdRemoteRoot}: {@code Failed to change to remote
     * directory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to change to remote directory [{0}]}
     */
    public static Localizable _exception_cwdRemoteRoot(Object arg0) {
        return new Localizable(holder, "exception.cwdRemoteRoot", arg0);
    }

    /**
     * Key {@code console.disconnecting}: {@code Disconnecting configuration
     * [{0}] ...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disconnecting configuration [{0}] ...}
     */
    public static String console_disconnecting(Object arg0) {
        return holder.format("console.disconnecting", arg0);
    }

    /**
     * Key {@code console.disconnecting}: {@code Disconnecting configuration
     * [{0}] ...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Disconnecting configuration [{0}] ...}
     */
    public static Localizable _console_disconnecting(Object arg0) {
        return new Localizable(holder, "console.disconnecting", arg0);
    }

    /**
     * Key {@code exception.flattenModeDuplicateFileName}: {@code Duplicate
     * filename detected in flatten mode. Filename [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate filename detected in flatten mode. Filename [{0}]}
     */
    public static String exception_flattenModeDuplicateFileName(Object arg0) {
        return holder.format("exception.flattenModeDuplicateFileName", arg0);
    }

    /**
     * Key {@code exception.flattenModeDuplicateFileName}: {@code Duplicate
     * filename detected in flatten mode. Filename [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Duplicate filename detected in flatten mode. Filename [{0}]}
     */
    public static Localizable _exception_flattenModeDuplicateFileName(Object arg0) {
        return new Localizable(holder, "exception.flattenModeDuplicateFileName", arg0);
    }

    /**
     * Key {@code exception.failedToGetEnvVars}: {@code Failed to get
     * Environment Vars from build}.
     * 
     * @return
     *     {@code Failed to get Environment Vars from build}
     */
    public static String exception_failedToGetEnvVars() {
        return holder.format("exception.failedToGetEnvVars");
    }

    /**
     * Key {@code exception.failedToGetEnvVars}: {@code Failed to get
     * Environment Vars from build}.
     * 
     * @return
     *     {@code Failed to get Environment Vars from build}
     */
    public static Localizable _exception_failedToGetEnvVars() {
        return new Localizable(holder, "exception.failedToGetEnvVars");
    }

    /**
     * Key {@code console.connecting}: {@code Connecting with configuration
     * [{0}] ...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting with configuration [{0}] ...}
     */
    public static String console_connecting(Object arg0) {
        return holder.format("console.connecting", arg0);
    }

    /**
     * Key {@code console.connecting}: {@code Connecting with configuration
     * [{0}] ...}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connecting with configuration [{0}] ...}
     */
    public static Localizable _console_connecting(Object arg0) {
        return new Localizable(holder, "console.connecting", arg0);
    }

    /**
     * Key {@code exception.removePrefix.noMatch}: {@code Failed to remove
     * prefix from file named [{0}]. Prefix [{1}] must be present in all file
     * paths}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to remove prefix from file named [{0}]. Prefix [{1}]
     *     must be present in all file paths}
     */
    public static String exception_removePrefix_noMatch(Object arg0, Object arg1) {
        return holder.format("exception.removePrefix.noMatch", arg0, arg1);
    }

    /**
     * Key {@code exception.removePrefix.noMatch}: {@code Failed to remove
     * prefix from file named [{0}]. Prefix [{1}] must be present in all file
     * paths}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to remove prefix from file named [{0}]. Prefix [{1}]
     *     must be present in all file paths}
     */
    public static Localizable _exception_removePrefix_noMatch(Object arg0, Object arg1) {
        return new Localizable(holder, "exception.removePrefix.noMatch", arg0, arg1);
    }

    /**
     * Key {@code exception.remoteCallException}: {@code Exception when
     * publishing, exception message [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception when publishing, exception message [{0}]}
     */
    public static String exception_remoteCallException(Object arg0) {
        return holder.format("exception.remoteCallException", arg0);
    }

    /**
     * Key {@code exception.remoteCallException}: {@code Exception when
     * publishing, exception message [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception when publishing, exception message [{0}]}
     */
    public static Localizable _exception_remoteCallException(Object arg0) {
        return new Localizable(holder, "exception.remoteCallException", arg0);
    }

    /**
     * Key {@code exception.badDateFormat}: {@code Could not create a date
     * format from [{0}] exception message [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create a date format from [{0}] exception message
     *     [{1}]}
     */
    public static String exception_badDateFormat(Object arg0, Object arg1) {
        return holder.format("exception.badDateFormat", arg0, arg1);
    }

    /**
     * Key {@code exception.badDateFormat}: {@code Could not create a date
     * format from [{0}] exception message [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create a date format from [{0}] exception message
     *     [{1}]}
     */
    public static Localizable _exception_badDateFormat(Object arg0, Object arg1) {
        return new Localizable(holder, "exception.badDateFormat", arg0, arg1);
    }

    /**
     * Key {@code log.sourceFiles}: {@code Source files: configured [{0}],
     * actual [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Source files: configured [{0}], actual [{1}]}
     */
    public static String log_sourceFiles(Object arg0, Object arg1) {
        return holder.format("log.sourceFiles", arg0, arg1);
    }

    /**
     * Key {@code log.sourceFiles}: {@code Source files: configured [{0}],
     * actual [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Source files: configured [{0}], actual [{1}]}
     */
    public static Localizable _log_sourceFiles(Object arg0, Object arg1) {
        return new Localizable(holder, "log.sourceFiles", arg0, arg1);
    }

    /**
     * Key {@code log.exceptionCaught.retrying}: {@code Exception caught.
     * Retrying.}.
     * 
     * @return
     *     {@code Exception caught. Retrying.}
     */
    public static String log_exceptionCaught_retrying() {
        return holder.format("log.exceptionCaught.retrying");
    }

    /**
     * Key {@code log.exceptionCaught.retrying}: {@code Exception caught.
     * Retrying.}.
     * 
     * @return
     *     {@code Exception caught. Retrying.}
     */
    public static Localizable _log_exceptionCaught_retrying() {
        return new Localizable(holder, "log.exceptionCaught.retrying");
    }

    /**
     * Key {@code log.envVars.pair}: {@code ** {0}={1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ** {0}={1}}
     */
    public static String log_envVars_pair(Object arg0, Object arg1) {
        return holder.format("log.envVars.pair", arg0, arg1);
    }

    /**
     * Key {@code log.envVars.pair}: {@code ** {0}={1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code ** {0}={1}}
     */
    public static Localizable _log_envVars_pair(Object arg0, Object arg1) {
        return new Localizable(holder, "log.envVars.pair", arg0, arg1);
    }

    /**
     * Key {@code log.pathToFile}: {@code Relative path to file [{0}] is
     * [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Relative path to file [{0}] is [{1}]}
     */
    public static String log_pathToFile(Object arg0, Object arg1) {
        return holder.format("log.pathToFile", arg0, arg1);
    }

    /**
     * Key {@code log.pathToFile}: {@code Relative path to file [{0}] is
     * [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Relative path to file [{0}] is [{1}]}
     */
    public static Localizable _log_pathToFile(Object arg0, Object arg1) {
        return new Localizable(holder, "log.pathToFile", arg0, arg1);
    }

    /**
     * Key {@code console.publishFromHost.unknown}: {@code Failed to get
     * hostname [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to get hostname [{0}]}
     */
    public static String console_publishFromHost_unknown(Object arg0) {
        return holder.format("console.publishFromHost.unknown", arg0);
    }

    /**
     * Key {@code console.publishFromHost.unknown}: {@code Failed to get
     * hostname [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to get hostname [{0}]}
     */
    public static Localizable _console_publishFromHost_unknown(Object arg0) {
        return new Localizable(holder, "console.publishFromHost.unknown", arg0);
    }

    /**
     * Key {@code exception.normalizeDirectory}: {@code Failed to normalize
     * base directory baseDirectory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to normalize base directory baseDirectory [{0}]}
     */
    public static String exception_normalizeDirectory(Object arg0) {
        return holder.format("exception.normalizeDirectory", arg0);
    }

    /**
     * Key {@code exception.normalizeDirectory}: {@code Failed to normalize
     * base directory baseDirectory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to normalize base directory baseDirectory [{0}]}
     */
    public static Localizable _exception_normalizeDirectory(Object arg0) {
        return new Localizable(holder, "exception.normalizeDirectory", arg0);
    }

    /**
     * Key {@code console.retryDelay}: {@code Caught exception [{0}] Sleeping
     * for [{1}]ms before trying again}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Caught exception [{0}] Sleeping for [{1}]ms before trying
     *     again}
     */
    public static String console_retryDelay(Object arg0, Object arg1) {
        return holder.format("console.retryDelay", arg0, arg1);
    }

    /**
     * Key {@code console.retryDelay}: {@code Caught exception [{0}] Sleeping
     * for [{1}]ms before trying again}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Caught exception [{0}] Sleeping for [{1}]ms before trying
     *     again}
     */
    public static Localizable _console_retryDelay(Object arg0, Object arg1) {
        return new Localizable(holder, "console.retryDelay", arg0, arg1);
    }

    /**
     * Key {@code console.paramPublish.match}: {@code Publishing to [{2}] -
     * Label [{0}] matches expression [{1}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Publishing to [{2}] - Label [{0}] matches expression [{1}]}
     */
    public static String console_paramPublish_match(Object arg0, Object arg1, Object arg2) {
        return holder.format("console.paramPublish.match", arg0, arg1, arg2);
    }

    /**
     * Key {@code console.paramPublish.match}: {@code Publishing to [{2}] -
     * Label [{0}] matches expression [{1}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Publishing to [{2}] - Label [{0}] matches expression [{1}]}
     */
    public static Localizable _console_paramPublish_match(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "console.paramPublish.match", arg0, arg1, arg2);
    }

    /**
     * Key {@code exception.failedToCreateDirectory}: {@code Could not create
     * or change to directory. Directory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create or change to directory. Directory [{0}]}
     */
    public static String exception_failedToCreateDirectory(Object arg0) {
        return holder.format("exception.failedToCreateDirectory", arg0);
    }

    /**
     * Key {@code exception.failedToCreateDirectory}: {@code Could not create
     * or change to directory. Directory [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not create or change to directory. Directory [{0}]}
     */
    public static Localizable _exception_failedToCreateDirectory(Object arg0) {
        return new Localizable(holder, "exception.failedToCreateDirectory", arg0);
    }

    /**
     * Key {@code log.envVars.head}: {@code Environment Variables}.
     * 
     * @return
     *     {@code Environment Variables}
     */
    public static String log_envVars_head() {
        return holder.format("log.envVars.head");
    }

    /**
     * Key {@code log.envVars.head}: {@code Environment Variables}.
     * 
     * @return
     *     {@code Environment Variables}
     */
    public static Localizable _log_envVars_head() {
        return new Localizable(holder, "log.envVars.head");
    }

    /**
     * Key {@code exception.paramPublish.badPattern}: {@code Bad regular
     * expression. Parameter name [{0}], value [{1}], message [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad regular expression. Parameter name [{0}], value [{1}],
     *     message [{2}]}
     */
    public static String exception_paramPublish_badPattern(Object arg0, Object arg1, Object arg2) {
        return holder.format("exception.paramPublish.badPattern", arg0, arg1, arg2);
    }

    /**
     * Key {@code exception.paramPublish.badPattern}: {@code Bad regular
     * expression. Parameter name [{0}], value [{1}], message [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad regular expression. Parameter name [{0}], value [{1}],
     *     message [{2}]}
     */
    public static Localizable _exception_paramPublish_badPattern(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "exception.paramPublish.badPattern", arg0, arg1, arg2);
    }

    /**
     * Key {@code validator.safeName}: {@code Required. Cannot contain {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Required. Cannot contain {0}}
     */
    public static String validator_safeName(Object arg0) {
        return holder.format("validator.safeName", arg0);
    }

    /**
     * Key {@code validator.safeName}: {@code Required. Cannot contain {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Required. Cannot contain {0}}
     */
    public static Localizable _validator_safeName(Object arg0) {
        return new Localizable(holder, "validator.safeName", arg0);
    }

    /**
     * Key {@code exception.failedToGetPromotedBuild}: {@code Build is a
     * Promotion, but failed to get the original build}.
     * 
     * @return
     *     {@code Build is a Promotion, but failed to get the original build}
     */
    public static String exception_failedToGetPromotedBuild() {
        return holder.format("exception.failedToGetPromotedBuild");
    }

    /**
     * Key {@code exception.failedToGetPromotedBuild}: {@code Build is a
     * Promotion, but failed to get the original build}.
     * 
     * @return
     *     {@code Build is a Promotion, but failed to get the original build}
     */
    public static Localizable _exception_failedToGetPromotedBuild() {
        return new Localizable(holder, "exception.failedToGetPromotedBuild");
    }

    /**
     * Key {@code exception.invokeList}: {@code Exception calling
     * FilePath.list. includes [{0}], excludes [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception calling FilePath.list. includes [{0}], excludes
     *     [{1}]}
     */
    public static String exception_invokeList(Object arg0, Object arg1) {
        return holder.format("exception.invokeList", arg0, arg1);
    }

    /**
     * Key {@code exception.invokeList}: {@code Exception calling
     * FilePath.list. includes [{0}], excludes [{1}]}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception calling FilePath.list. includes [{0}], excludes
     *     [{1}]}
     */
    public static Localizable _exception_invokeList(Object arg0, Object arg1) {
        return new Localizable(holder, "exception.invokeList", arg0, arg1);
    }

    /**
     * Key {@code console.paramPublish.skip}: {@code Skipping [{2}] - Label
     * [{0}] does not match expression [{1}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipping [{2}] - Label [{0}] does not match expression [{1}]}
     */
    public static String console_paramPublish_skip(Object arg0, Object arg1, Object arg2) {
        return holder.format("console.paramPublish.skip", arg0, arg1, arg2);
    }

    /**
     * Key {@code console.paramPublish.skip}: {@code Skipping [{2}] - Label
     * [{0}] does not match expression [{1}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipping [{2}] - Label [{0}] does not match expression [{1}]}
     */
    public static Localizable _console_paramPublish_skip(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "console.paramPublish.skip", arg0, arg1, arg2);
    }

    /**
     * Key {@code exception.failedToFindConfiguration}: {@code Failed to find
     * configuration named [{0}] check the global configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to find configuration named [{0}] check the global
     *     configuration}
     */
    public static String exception_failedToFindConfiguration(Object arg0) {
        return holder.format("exception.failedToFindConfiguration", arg0);
    }

    /**
     * Key {@code exception.failedToFindConfiguration}: {@code Failed to find
     * configuration named [{0}] check the global configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to find configuration named [{0}] check the global
     *     configuration}
     */
    public static Localizable _exception_failedToFindConfiguration(Object arg0) {
        return new Localizable(holder, "exception.failedToFindConfiguration", arg0);
    }

    /**
     * Key {@code log.exceptionInPerform}: {@code An exception was caught
     * when invoking perform}.
     * 
     * @return
     *     {@code An exception was caught when invoking perform}
     */
    public static String log_exceptionInPerform() {
        return holder.format("log.exceptionInPerform");
    }

    /**
     * Key {@code log.exceptionInPerform}: {@code An exception was caught
     * when invoking perform}.
     * 
     * @return
     *     {@code An exception was caught when invoking perform}
     */
    public static Localizable _log_exceptionInPerform() {
        return new Localizable(holder, "log.exceptionInPerform");
    }

    /**
     * Key {@code exception.invokeListNoDefaultExcludes}: {@code Exception
     * calling FilePath.list. includes [{0}], excludes [{1}],
     * noDefaultExcludes [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception calling FilePath.list. includes [{0}], excludes
     *     [{1}], noDefaultExcludes [{2}]}
     */
    public static String exception_invokeListNoDefaultExcludes(Object arg0, Object arg1, Object arg2) {
        return holder.format("exception.invokeListNoDefaultExcludes", arg0, arg1, arg2);
    }

    /**
     * Key {@code exception.invokeListNoDefaultExcludes}: {@code Exception
     * calling FilePath.list. includes [{0}], excludes [{1}],
     * noDefaultExcludes [{2}]}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Exception calling FilePath.list. includes [{0}], excludes
     *     [{1}], noDefaultExcludes [{2}]}
     */
    public static Localizable _exception_invokeListNoDefaultExcludes(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "exception.invokeListNoDefaultExcludes", arg0, arg1, arg2);
    }

    /**
     * Key {@code exception.paramPublish.noParameter}: {@code Failed to find
     * parameter named [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to find parameter named [{0}]}
     */
    public static String exception_paramPublish_noParameter(Object arg0) {
        return holder.format("exception.paramPublish.noParameter", arg0);
    }

    /**
     * Key {@code exception.paramPublish.noParameter}: {@code Failed to find
     * parameter named [{0}]}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to find parameter named [{0}]}
     */
    public static Localizable _exception_paramPublish_noParameter(Object arg0) {
        return new Localizable(holder, "exception.paramPublish.noParameter", arg0);
    }

}
