/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.service;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.service.DefaultPrometheusMetrics;
import org.jenkinsci.plugins.prometheus.service.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PrometheusAsyncWorker
extends AsyncPeriodicWork {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusAsyncWorker.class);
    private final PrometheusMetrics prometheusMetrics = DefaultPrometheusMetrics.get();

    public PrometheusAsyncWorker() {
        super("prometheus_async_worker");
    }

    public long getRecurrencePeriod() {
        long collectingMetricsPeriodInMillis = TimeUnit.SECONDS.toMillis(PrometheusConfiguration.get().getCollectingMetricsPeriodInSeconds());
        logger.debug("Setting recurrence period to {} in milliseconds", (Object)collectingMetricsPeriodInMillis);
        return collectingMetricsPeriodInMillis;
    }

    public void execute(TaskListener taskListener) {
        logger.debug("Collecting prometheus metrics");
        this.prometheusMetrics.collectMetrics();
        logger.debug("Prometheus metrics collected successfully");
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }
}

