/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.config.disabledmetrics;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.MetricStatusChecker;

public class FilteredMetricEnumeration
implements Enumeration<Collector.MetricFamilySamples> {
    private final Iterator<Collector.MetricFamilySamples> filteredList;

    public FilteredMetricEnumeration(Iterator<Collector.MetricFamilySamples> fullList) {
        this.filteredList = this.filterList(fullList);
    }

    private Iterator<Collector.MetricFamilySamples> filterList(Iterator<Collector.MetricFamilySamples> fullList) {
        ArrayList<Collector.MetricFamilySamples> filteredList = new ArrayList<Collector.MetricFamilySamples>();
        while (fullList.hasNext()) {
            Collector.MetricFamilySamples familySamples = fullList.next();
            if (!MetricStatusChecker.isEnabled(familySamples.name)) continue;
            filteredList.add(familySamples);
        }
        return filteredList.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.filteredList.hasNext();
    }

    @Override
    public Collector.MetricFamilySamples nextElement() {
        return this.filteredList.next();
    }

    @Override
    public Iterator<Collector.MetricFamilySamples> asIterator() {
        return this.filteredList;
    }
}

