/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.prometheus.config.Messages;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.DisabledMetricConfig;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(dynamicLoadable=YesNoMaybe.NO)
public class PrometheusConfiguration
extends GlobalConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusConfiguration.class);
    private static final String PROMETHEUS_ENDPOINT = "PROMETHEUS_ENDPOINT";
    private static final String DEFAULT_ENDPOINT = "prometheus";
    static final String COLLECTING_METRICS_PERIOD_IN_SECONDS = "COLLECTING_METRICS_PERIOD_IN_SECONDS";
    static final long DEFAULT_COLLECTING_METRICS_PERIOD_IN_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    static final String COLLECT_DISK_USAGE = "COLLECT_DISK_USAGE";
    private String urlName = null;
    private String additionalPath;
    private String defaultNamespace = "default";
    private String jobAttributeName = "jenkins_job";
    private boolean useAuthenticatedEndpoint;
    private long collectingMetricsPeriodInSeconds = -1L;
    private boolean countSuccessfulBuilds = true;
    private boolean countUnstableBuilds = true;
    private boolean countFailedBuilds = true;
    private boolean countNotBuiltBuilds = true;
    private boolean countAbortedBuilds = true;
    private boolean fetchTestResults = true;
    private boolean processingDisabledBuilds = false;
    private boolean appendParamLabel = false;
    private boolean appendStatusLabel = false;
    private boolean perBuildMetrics = false;
    private transient boolean collectDiskUsageEnvironmentVariableSet = false;
    private String labeledBuildParameterNames = "";
    private boolean collectDiskUsage = true;
    private boolean collectCodeCoverage = false;
    private boolean collectNodeStatus = true;
    @CheckForNull
    private DisabledMetricConfig disabledMetricConfig;

    public PrometheusConfiguration() {
        this.load();
        this.setPath(this.getPath());
        this.setCollectingMetricsPeriodInSeconds(this.collectingMetricsPeriodInSeconds);
        this.setCollectDiskUsageBasedOnEnvironmentVariableIfDefined();
    }

    public static PrometheusConfiguration get() {
        return (PrometheusConfiguration)Jenkins.get().getDescriptor(PrometheusConfiguration.class);
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) {
        this.disabledMetricConfig = null;
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public String getPath() {
        return StringUtils.isEmpty((CharSequence)this.additionalPath) ? this.urlName : this.urlName + this.additionalPath;
    }

    @DataBoundSetter
    public void setPath(String path) {
        if (path == null) {
            Map<String, String> env = System.getenv();
            path = env.getOrDefault(PROMETHEUS_ENDPOINT, DEFAULT_ENDPOINT);
        }
        this.urlName = path.split("/")[0];
        List<String> pathParts = Arrays.asList(path.split("/"));
        this.additionalPath = (pathParts.size() > 1 ? "/" : "") + StringUtils.join(pathParts.subList(1, pathParts.size()), (String)"/");
    }

    public String getJobAttributeName() {
        return this.jobAttributeName;
    }

    @DataBoundSetter
    public void setJobAttributeName(String jobAttributeName) {
        this.jobAttributeName = jobAttributeName;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @DataBoundSetter
    public void setDefaultNamespace(String path) {
        this.defaultNamespace = path;
    }

    @DataBoundSetter
    public void setCollectDiskUsage(boolean collectDiskUsage) {
        this.collectDiskUsage = collectDiskUsage;
    }

    public void setCollectDiskUsageBasedOnEnvironmentVariableIfDefined() {
        try {
            String envValue = System.getenv(COLLECT_DISK_USAGE);
            if (envValue != null) {
                this.setCollectDiskUsage(this.getValidBooleanValueOrThrowException(envValue));
                this.collectDiskUsageEnvironmentVariableSet = true;
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to parse environment variable '{}'. Must either be 'true' or 'false'. Ignoring...", (Object)COLLECT_DISK_USAGE);
        }
    }

    public boolean isCollectDiskUsageEnvironmentVariableSet() {
        return this.collectDiskUsageEnvironmentVariableSet;
    }

    private boolean getValidBooleanValueOrThrowException(String value) throws IllegalArgumentException {
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return Boolean.parseBoolean(value);
        }
        throw new IllegalArgumentException();
    }

    public boolean getCollectDiskUsage() {
        return this.collectDiskUsage;
    }

    public long getCollectingMetricsPeriodInSeconds() {
        return this.collectingMetricsPeriodInSeconds;
    }

    @DataBoundSetter
    public void setCollectingMetricsPeriodInSeconds(long collectingMetricsPeriodInSeconds) {
        this.collectingMetricsPeriodInSeconds = collectingMetricsPeriodInSeconds == -1L ? this.parseLongFromEnv() : collectingMetricsPeriodInSeconds;
    }

    public boolean isUseAuthenticatedEndpoint() {
        return this.useAuthenticatedEndpoint;
    }

    @DataBoundSetter
    public void setUseAuthenticatedEndpoint(boolean useAuthenticatedEndpoint) {
        this.useAuthenticatedEndpoint = useAuthenticatedEndpoint;
    }

    public boolean isCountSuccessfulBuilds() {
        return this.countSuccessfulBuilds;
    }

    @DataBoundSetter
    public void setCountSuccessfulBuilds(boolean countSuccessfulBuilds) {
        this.countSuccessfulBuilds = countSuccessfulBuilds;
    }

    public boolean isCountUnstableBuilds() {
        return this.countUnstableBuilds;
    }

    @DataBoundSetter
    public void setCountUnstableBuilds(boolean countUnstableBuilds) {
        this.countUnstableBuilds = countUnstableBuilds;
    }

    public boolean isCountFailedBuilds() {
        return this.countFailedBuilds;
    }

    @DataBoundSetter
    public void setCountFailedBuilds(boolean countFailedBuilds) {
        this.countFailedBuilds = countFailedBuilds;
    }

    public boolean isCountNotBuiltBuilds() {
        return this.countNotBuiltBuilds;
    }

    @DataBoundSetter
    public void setCountNotBuiltBuilds(boolean countNotBuiltBuilds) {
        this.countNotBuiltBuilds = countNotBuiltBuilds;
    }

    public boolean isCountAbortedBuilds() {
        return this.countAbortedBuilds;
    }

    @DataBoundSetter
    public void setCountAbortedBuilds(boolean countAbortedBuilds) {
        this.countAbortedBuilds = countAbortedBuilds;
    }

    public boolean isFetchTestResults() {
        return this.fetchTestResults;
    }

    @DataBoundSetter
    public void setFetchTestResults(boolean fetchTestResults) {
        this.fetchTestResults = fetchTestResults;
    }

    public boolean isProcessingDisabledBuilds() {
        return this.processingDisabledBuilds;
    }

    @DataBoundSetter
    public void setProcessingDisabledBuilds(boolean processingDisabledBuilds) {
        this.processingDisabledBuilds = processingDisabledBuilds;
    }

    public boolean isAppendParamLabel() {
        return this.appendParamLabel;
    }

    @DataBoundSetter
    public void setAppendParamLabel(boolean appendParamLabel) {
        this.appendParamLabel = appendParamLabel;
    }

    public boolean isAppendStatusLabel() {
        return this.appendStatusLabel;
    }

    @DataBoundSetter
    public void setAppendStatusLabel(boolean appendStatusLabel) {
        this.appendStatusLabel = appendStatusLabel;
    }

    public boolean isPerBuildMetrics() {
        return this.perBuildMetrics;
    }

    @DataBoundSetter
    public void setPerBuildMetrics(boolean perBuildMetrics) {
        this.perBuildMetrics = perBuildMetrics;
    }

    public boolean isCollectNodeStatus() {
        return this.collectNodeStatus;
    }

    @DataBoundSetter
    public void setCollectNodeStatus(boolean collectNodeStatus) {
        this.collectNodeStatus = collectNodeStatus;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public String getAdditionalPath() {
        return this.additionalPath;
    }

    public String getLabeledBuildParameterNames() {
        return this.labeledBuildParameterNames;
    }

    @DataBoundSetter
    public void setLabeledBuildParameterNames(String labeledBuildParameterNames) {
        this.labeledBuildParameterNames = labeledBuildParameterNames;
    }

    public String[] getLabeledBuildParameterNamesAsArray() {
        return this.parseParameterNamesFromStringSeparatedByComma(this.labeledBuildParameterNames);
    }

    public DisabledMetricConfig getDisabledMetricConfig() {
        return this.disabledMetricConfig;
    }

    @DataBoundSetter
    public void setDisabledMetricConfig(DisabledMetricConfig disabledMetricConfig) {
        this.disabledMetricConfig = disabledMetricConfig;
    }

    public boolean isCollectCodeCoverage() {
        return this.collectCodeCoverage;
    }

    public boolean isCodeCoverageApiPluginInstalled() {
        return Jenkins.get().getPlugin("code-coverage-api") != null;
    }

    public void setCollectCodeCoverage(boolean collectCodeCoverage) {
        this.collectCodeCoverage = collectCodeCoverage;
    }

    public FormValidation doCheckPath(@QueryParameter String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return FormValidation.error((String)Messages.path_required());
        }
        if (System.getenv().containsKey(PROMETHEUS_ENDPOINT)) {
            return FormValidation.warning((String)Messages.path_environment_override(PROMETHEUS_ENDPOINT, System.getenv(PROMETHEUS_ENDPOINT)));
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckCollectingMetricsPeriodInSeconds(@QueryParameter String value) {
        try {
            long longValue = Long.parseLong(value);
            if (longValue > 0L) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return FormValidation.error((String)"CollectingMetricsPeriodInSeconds must be a positive value");
    }

    private long parseLongFromEnv() {
        Map<String, String> env = System.getenv();
        String message = String.format("COLLECTING_METRICS_PERIOD_IN_SECONDS must be a positive integer. The default value: '%d' will be used instead of provided.", DEFAULT_COLLECTING_METRICS_PERIOD_IN_SECONDS);
        try {
            return Optional.ofNullable(env.get(COLLECTING_METRICS_PERIOD_IN_SECONDS)).map(Long::parseLong).filter(v -> v > 0L).orElseGet(() -> {
                logger.warn(message);
                return DEFAULT_COLLECTING_METRICS_PERIOD_IN_SECONDS;
            });
        }
        catch (NumberFormatException e) {
            logger.warn(message);
            return DEFAULT_COLLECTING_METRICS_PERIOD_IN_SECONDS;
        }
    }

    private String[] parseParameterNamesFromStringSeparatedByComma(String stringValue) {
        if (stringValue == null || stringValue.trim().isEmpty()) {
            return new String[0];
        }
        return stringValue.split("\\s*,\\s*");
    }
}

