/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.jobs;

import hudson.model.Job;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildsMetricCollector;

public class NbBuildsGauge
extends BuildsMetricCollector<Job<?, ?>, Gauge> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected NbBuildsGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.NB_BUILDS_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Number of builds available for this job";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateMetric(Job<?, ?> jenkinsObject, String[] labelValues) {
        this.lock.readLock().lock();
        try {
            int nbBuilds = jenkinsObject.getBuildsAsMap().size();
            ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set((double)nbBuilds);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

