/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.executors;

import hudson.model.LoadStatistics;
import io.prometheus.client.Collector;
import org.jenkinsci.plugins.prometheus.collectors.BaseCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.NoOpMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsAvailableGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsBusyGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsConnectingGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsDefinedGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsIdleGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsOnlineGauge;
import org.jenkinsci.plugins.prometheus.collectors.executors.ExecutorsQueueLengthGauge;

public class ExecutorCollectorFactory
extends BaseCollectorFactory {
    public MetricCollector<LoadStatistics.LoadStatisticsSnapshot, ? extends Collector> createCollector(CollectorType type, String[] labelNames, String prefix) {
        switch (type) {
            case EXECUTORS_AVAILABLE_GAUGE: {
                return this.saveBuildCollector(new ExecutorsAvailableGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_BUSY_GAUGE: {
                return this.saveBuildCollector(new ExecutorsBusyGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_CONNECTING_GAUGE: {
                return this.saveBuildCollector(new ExecutorsConnectingGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_DEFINED_GAUGE: {
                return this.saveBuildCollector(new ExecutorsDefinedGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_IDLE_GAUGE: {
                return this.saveBuildCollector(new ExecutorsIdleGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_ONLINE_GAUGE: {
                return this.saveBuildCollector(new ExecutorsOnlineGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case EXECUTORS_QUEUE_LENGTH_GAUGE: {
                return this.saveBuildCollector(new ExecutorsQueueLengthGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
        }
        return new NoOpMetricCollector();
    }
}

