/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.util.Runs;

public class JobLabel {
    private static final String NOT_AVAILABLE = "NA";
    private static final String UNDEFINED = "UNDEFINED";

    public static String[] getBaseLabelNames() {
        String jobAttribute = PrometheusConfiguration.get().getJobAttributeName();
        return new String[]{jobAttribute, "repo", "buildable"};
    }

    public static String[] getJobLabelNames() {
        String[] buildParameterNamesAsArray;
        String[] labelNameArray = JobLabel.getBaseLabelNames();
        if (PrometheusConfiguration.get().isAppendParamLabel()) {
            labelNameArray = Arrays.copyOf(labelNameArray, labelNameArray.length + 1);
            labelNameArray[labelNameArray.length - 1] = "parameters";
        }
        if (PrometheusConfiguration.get().isAppendStatusLabel()) {
            labelNameArray = Arrays.copyOf(labelNameArray, labelNameArray.length + 1);
            labelNameArray[labelNameArray.length - 1] = "status";
        }
        for (String buildParam : buildParameterNamesAsArray = PrometheusConfiguration.get().getLabeledBuildParameterNamesAsArray()) {
            labelNameArray = Arrays.copyOf(labelNameArray, labelNameArray.length + 1);
            labelNameArray[labelNameArray.length - 1] = buildParam.trim();
        }
        return labelNameArray;
    }

    public static String[] getBaseLabelValues(Job<?, ?> job) {
        String repoName = StringUtils.substringBetween((String)job.getFullName(), (String)"/");
        if (repoName == null) {
            repoName = NOT_AVAILABLE;
        }
        return new String[]{job.getFullName(), repoName, String.valueOf(job.isBuildable())};
    }

    public static String[] getJobLabelValues(Job<?, ?> job, Run<?, ?> run) {
        boolean isAppendParamLabel = PrometheusConfiguration.get().isAppendParamLabel();
        boolean isAppendStatusLabel = PrometheusConfiguration.get().isAppendStatusLabel();
        String[] buildParameterNamesAsArray = PrometheusConfiguration.get().getLabeledBuildParameterNamesAsArray();
        Result runResult = run.getResult();
        String[] labelValueArray = JobLabel.getBaseLabelValues(job);
        if (isAppendParamLabel) {
            String params = Runs.getBuildParameters(run).entrySet().stream().map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(";"));
            labelValueArray = Arrays.copyOf(labelValueArray, labelValueArray.length + 1);
            labelValueArray[labelValueArray.length - 1] = params;
        }
        if (isAppendStatusLabel) {
            String resultString = UNDEFINED;
            if (runResult != null) {
                resultString = runResult.toString();
            }
            labelValueArray = Arrays.copyOf(labelValueArray, labelValueArray.length + 1);
            labelValueArray[labelValueArray.length - 1] = run.isBuilding() ? "RUNNING" : resultString;
        }
        for (String configBuildParam : buildParameterNamesAsArray) {
            labelValueArray = Arrays.copyOf(labelValueArray, labelValueArray.length + 1);
            String paramValue = UNDEFINED;
            Object paramInBuild = Runs.getBuildParameters(run).get(configBuildParam);
            if (paramInBuild != null) {
                paramValue = String.valueOf(paramInBuild);
            }
            labelValueArray[labelValueArray.length - 1] = paramValue;
        }
        return labelValueArray;
    }
}

