/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import hudson.model.Run;
import io.prometheus.client.Collector;
import org.jenkinsci.plugins.prometheus.collectors.BaseCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.NoOpMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildAbortedCounter;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildDurationGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildDurationSummary;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildFailedCounter;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildLikelyStuckGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildLogFileSizeGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildResultGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildResultOrdinalGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildStartGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildSuccessfulCounter;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildTotalCounter;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildUnstableCounter;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildWaitingDurationGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.FailedTestsGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.SkippedTestsGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.StageBuildResultOrdinalGauge;
import org.jenkinsci.plugins.prometheus.collectors.builds.StageSummary;
import org.jenkinsci.plugins.prometheus.collectors.builds.TotalTestsGauge;

public class BuildCollectorFactory
extends BaseCollectorFactory {
    public MetricCollector<Run<?, ?>, ? extends Collector> createCollector(CollectorType type, String[] labelNames, String prefix) {
        switch (type) {
            case BUILD_DURATION_GAUGE: {
                return this.saveBuildCollector(new BuildDurationGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_DURATION_SUMMARY: {
                return this.saveBuildCollector(new BuildDurationSummary(labelNames, this.namespace, this.subsystem));
            }
            case BUILD_FAILED_COUNTER: {
                return this.saveBuildCollector(new BuildFailedCounter(labelNames, this.namespace, this.subsystem));
            }
            case BUILD_RESULT_GAUGE: {
                return this.saveBuildCollector(new BuildResultGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_RESULT_ORDINAL_GAUGE: {
                return this.saveBuildCollector(new BuildResultOrdinalGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_START_GAUGE: {
                return this.saveBuildCollector(new BuildStartGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_SUCCESSFUL_COUNTER: {
                return this.saveBuildCollector(new BuildSuccessfulCounter(labelNames, this.namespace, this.subsystem));
            }
            case FAILED_TESTS_GAUGE: {
                return this.saveBuildCollector(new FailedTestsGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case SKIPPED_TESTS_GAUGE: {
                return this.saveBuildCollector(new SkippedTestsGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case STAGE_SUMMARY: {
                return this.saveBuildCollector(new StageSummary(labelNames, this.namespace, this.subsystem, prefix));
            }
            case STAGE_BUILDRESULT_ORDINAL: {
                return this.saveBuildCollector(new StageBuildResultOrdinalGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case TOTAL_TESTS_GAUGE: {
                return this.saveBuildCollector(new TotalTestsGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_LIKELY_STUCK_GAUGE: {
                return this.saveBuildCollector(new BuildLikelyStuckGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_ABORTED_COUNTER: {
                return this.saveBuildCollector(new BuildAbortedCounter(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_UNSTABLE_COUNTER: {
                return this.saveBuildCollector(new BuildUnstableCounter(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_TOTAL_COUNTER: {
                return this.saveBuildCollector(new BuildTotalCounter(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_LOGFILE_SIZE_GAUGE: {
                return this.saveBuildCollector(new BuildLogFileSizeGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
            case BUILD_WAITING_GAUGE: {
                return this.saveBuildCollector(new BuildWaitingDurationGauge(labelNames, this.namespace, this.subsystem, prefix));
            }
        }
        return new NoOpMetricCollector();
    }
}

