/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildCondition;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPostBuild;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPostStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.Converter;
import org.jenkinsci.plugins.pluginusage.analyzer.AbstractProjectAnalyzer;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.HeterogeneousObjectType;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

class PipelineProjectAnalyzer
extends AbstractProjectAnalyzer {
    private final Map<String, PluginWrapper> pluginPerFunction = new HashMap<String, PluginWrapper>();
    private final boolean hasPlugin;

    public PipelineProjectAnalyzer() {
        boolean bl = this.hasPlugin = Jenkins.get().getPlugin("pipeline-model-definition") != null;
        if (this.hasPlugin) {
            for (StepDescriptor b : StepDescriptor.all()) {
                DescribableParameter delegate;
                DescribableModel m;
                Collection parameters;
                if (b.isAdvanced()) continue;
                this.pluginPerFunction.put(b.getFunctionName(), this.getPluginFromClass(b.clazz));
                if (!b.isMetaStep() || (parameters = (m = new DescribableModel(b.clazz)).getParameters()).size() != 1 || !(delegate = (DescribableParameter)parameters.iterator().next()).isRequired() || !(delegate.getType() instanceof HeterogeneousObjectType)) continue;
                for (DescribableModel delegateOptionSchema : ((HeterogeneousObjectType)delegate.getType()).getTypes().values()) {
                    Set symbols;
                    Class delegateOptionType = delegateOptionSchema.getType();
                    Descriptor delegateDescriptor = Jenkins.get().getDescriptorOrDie(delegateOptionType.asSubclass(Describable.class));
                    PluginWrapper usedPlugin = this.getPluginFromClass(delegateDescriptor.clazz);
                    if (usedPlugin == null || (symbols = SymbolLookup.getSymbolValue((Object)delegateDescriptor)).isEmpty()) continue;
                    for (String symbol : symbols) {
                        this.pluginPerFunction.put(symbol, usedPlugin);
                    }
                }
            }
        }
    }

    @Override
    protected Set<PluginWrapper> getPlugins() {
        Set<PluginWrapper> plugins = super.getPlugins();
        if (!this.hasPlugin) {
            return plugins;
        }
        for (StepDescriptor b : StepDescriptor.all()) {
            plugins.add(this.getPluginFromClass(b.clazz));
        }
        return plugins;
    }

    @Override
    protected Set<PluginWrapper> getPluginsFromBuilders(Item item) {
        ModelASTPipelineDef model;
        WorkflowJob job;
        FlowDefinition definition;
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (!this.hasPlugin) {
            return plugins;
        }
        if (item instanceof WorkflowJob && (definition = (job = (WorkflowJob)item).getDefinition()) instanceof CpsFlowDefinition && (model = Converter.scriptToPipelineDef((String)((CpsFlowDefinition)definition).getScript())) != null) {
            Object branch2;
            ModelASTStages stages = model.getStages();
            for (ModelASTStage stage : stages.getStages()) {
                for (Object branch2 : stage.getBranches()) {
                    for (ModelASTStep step : branch2.getSteps()) {
                        if (!this.pluginPerFunction.containsKey(step.getName())) continue;
                        plugins.add(this.pluginPerFunction.get(step.getName()));
                    }
                }
                ModelASTPostStage postStage = stage.getPost();
                if (postStage == null) continue;
                branch2 = postStage.getConditions().iterator();
                while (branch2.hasNext()) {
                    ModelASTBuildCondition condition = (ModelASTBuildCondition)branch2.next();
                    ModelASTBranch branch3 = condition.getBranch();
                    for (ModelASTStep step : branch3.getSteps()) {
                        if (!this.pluginPerFunction.containsKey(step.getName())) continue;
                        plugins.add(this.pluginPerFunction.get(step.getName()));
                    }
                }
            }
            ModelASTPostBuild postBuild = model.getPostBuild();
            if (postBuild != null) {
                for (ModelASTBuildCondition condition : postBuild.getConditions()) {
                    branch2 = condition.getBranch();
                    for (ModelASTStep step : branch2.getSteps()) {
                        if (!this.pluginPerFunction.containsKey(step.getName())) continue;
                        plugins.add(this.pluginPerFunction.get(step.getName()));
                    }
                }
            }
        }
        return plugins;
    }
}

