/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage.analyzer;

import hudson.PluginWrapper;
import hudson.maven.MavenModuleSet;
import hudson.model.Item;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.analyzer.AbstractProjectAnalyzer;

class MavenProjectAnalyzer
extends AbstractProjectAnalyzer {
    MavenProjectAnalyzer() {
    }

    @Override
    protected Set<PluginWrapper> getPluginsFromBuilders(Item item) {
        HashSet<PluginWrapper> plugins = new HashSet<PluginWrapper>();
        if (Jenkins.get().getPlugin("maven-plugin") == null) {
            return plugins;
        }
        if (item instanceof MavenModuleSet) {
            plugins.add(this.getPluginFromClass(MavenModuleSet.DescriptorImpl.class));
            MavenModuleSet moduleSet = (MavenModuleSet)item;
            for (Builder builder : moduleSet.getPrebuilders()) {
                plugins.addAll(this.getPluginsFromBuilder(builder));
            }
            for (Builder builder : moduleSet.getPostbuilders()) {
                plugins.addAll(this.getPluginsFromBuilder(builder));
            }
            for (BuildWrapper buildWrapper : moduleSet.getBuildWrappersList()) {
                plugins.add(this.getPluginFromClass(buildWrapper.getDescriptor().clazz));
            }
        }
        return plugins;
    }
}

