/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pluginusage;

import hudson.PluginWrapper;
import hudson.Util;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pluginusage.JobsPerPlugin;
import org.jenkinsci.plugins.pluginusage.PersistedModel;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class PluginUsageModel {
    private transient PersistedModel persistedModel;

    @Exported
    public List<JobsPerPlugin> getJobsPerPlugin() {
        ArrayList<JobsPerPlugin> list = new ArrayList<JobsPerPlugin>(this.getPersistedModel().getJobsPerPlugin().values());
        list.sort(Comparator.comparing(JobsPerPlugin::getPluginName));
        return list;
    }

    public int getNumberOfJobs() {
        return this.getPersistedModel().getJobsPerPlugin().values().stream().flatMap(jobsPerPlugin -> jobsPerPlugin.getProjects().stream()).collect(Collectors.toSet()).size();
    }

    @Exported
    public List<PluginWrapper> getOtherPlugins() {
        List allPlugins = Jenkins.get().getPluginManager().getPlugins();
        ArrayList<PluginWrapper> others = new ArrayList<PluginWrapper>(allPlugins);
        others.removeAll(this.getPersistedModel().getJobsPerPlugin().keySet());
        others.sort(Comparator.comparing(PluginWrapper::getDisplayName));
        return others;
    }

    public Instant getTimestamp() {
        return this.getPersistedModel().getTimestamp();
    }

    public String getTimestampStr() {
        if (this.getTimestamp() != null) {
            return Util.getTimeSpanString((long)(System.currentTimeMillis() - this.getTimestamp().toEpochMilli()));
        }
        return null;
    }

    private Map<PluginWrapper, JobsPerPlugin> getMapJobsPerPlugin() {
        return this.getPersistedModel().getJobsPerPlugin();
    }

    private PersistedModel getPersistedModel() {
        if (this.persistedModel == null) {
            this.persistedModel = new PersistedModel();
            this.persistedModel.load();
        }
        return this.persistedModel;
    }
}

