/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.db;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.maven.MavenArtifact;
import org.jenkinsci.plugins.pipeline.maven.MavenDependency;
import org.jenkinsci.plugins.pipeline.maven.dao.CustomTypePipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.dao.MonitoringPipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginNullDao;
import org.jenkinsci.plugins.pipeline.maven.dao.UpstreamMemory;
import org.jenkinsci.plugins.pipeline.maven.db.PipelineMavenPluginH2Dao;
import org.jenkinsci.plugins.pipeline.maven.db.migration.MigrationStep;
import org.jenkinsci.plugins.pipeline.maven.db.util.ClassUtils;
import org.jenkinsci.plugins.pipeline.maven.db.util.RuntimeIoException;
import org.jenkinsci.plugins.pipeline.maven.db.util.RuntimeSqlException;

public abstract class AbstractPipelineMavenPluginDao
implements PipelineMavenPluginDao {
    private static final int OPTIMIZATION_MAX_RECURSION_DEPTH = Integer.getInteger("org.jenkinsci.plugins.pipeline.PipelineMavenPluginDao.OPTIMIZATION_MAX_RECURSION_DEPTH", 3);
    protected final Logger LOGGER = Logger.getLogger(this.getClass().getName());
    @NonNull
    private transient DataSource ds;
    @Nullable
    private transient Long jenkinsMasterPrimaryKey;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    protected AbstractPipelineMavenPluginDao() {
    }

    public AbstractPipelineMavenPluginDao(@NonNull DataSource ds) {
        Objects.requireNonNull(ds, "Datasource cannot be null");
        this.ds = ds;
        this.registerJdbcDriver();
        this.initializeDatabase();
        this.testDatabase();
    }

    protected boolean acceptNoCredentials() {
        return false;
    }

    public PipelineMavenPluginDao.Builder getBuilder() {
        return new JDBCDaoBuilder(this.getClass());
    }

    private static HikariConfig createHikariConfig(String properties, String jdbcUrl, String jdbcUserName, String jdbcPassword) {
        Properties p = new Properties();
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            p.setProperty("dataSource.cachePrepStmts", "true");
            p.setProperty("dataSource.prepStmtCacheSize", "250");
            p.setProperty("dataSource.prepStmtCacheSqlLimit", "2048");
            p.setProperty("dataSource.useServerPrepStmts", "true");
            p.setProperty("dataSource.useLocalSessionState", "true");
            p.setProperty("dataSource.rewriteBatchedStatements", "true");
            p.setProperty("dataSource.cacheResultSetMetadata", "true");
            p.setProperty("dataSource.cacheServerConfiguration", "true");
            p.setProperty("dataSource.elideSetAutoCommits", "true");
            p.setProperty("dataSource.maintainTimeStats", "false");
        } else if (jdbcUrl.startsWith("jdbc:postgresql") || jdbcUrl.startsWith("jdbc:h2")) {
            // empty if block
        }
        if (StringUtils.isNotBlank((String)properties)) {
            try {
                p.load(new StringReader(properties));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read properties.", e);
            }
        }
        Logger.getLogger(AbstractPipelineMavenPluginDao.class.getName()).log(Level.INFO, "Applied pool properties {0}", p);
        HikariConfig dsConfig = new HikariConfig(p);
        dsConfig.setJdbcUrl(jdbcUrl);
        dsConfig.setUsername(jdbcUserName);
        dsConfig.setPassword(jdbcPassword);
        dsConfig.setDataSourceProperties(p);
        return dsConfig;
    }

    protected abstract void registerJdbcDriver();

    public void recordDependency(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String scope, boolean ignoreUpstreamTriggers, String classifier) {
        this.LOGGER.log(Level.FINE, "recordDependency({0}#{1}, {2}:{3}:{4}:{5}, {6}, ignoreUpstreamTriggers:{7}})", new Object[]{jobFullName, buildNumber, groupId, artifactId, version, type, scope, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, version, type, classifier);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_DEPENDENCY(ARTIFACT_ID, BUILD_ID, SCOPE, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, scope);
                stmt.setBoolean(4, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @NonNull
    public List<MavenDependency> listDependencies(@NonNull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String dependenciesSql = "SELECT DISTINCT MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier,  MAVEN_DEPENDENCY.scope  FROM MAVEN_ARTIFACT  INNER JOIN MAVEN_DEPENDENCY ON MAVEN_ARTIFACT.ID = MAVEN_DEPENDENCY.ARTIFACT_ID INNER JOIN JENKINS_BUILD ON MAVEN_DEPENDENCY.BUILD_ID = JENKINS_BUILD.ID  INNER JOIN JENKINS_JOB ON JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID  WHERE    JENKINS_JOB.FULL_NAME = ? AND   JENKINS_JOB.JENKINS_MASTER_ID = ? AND   JENKINS_BUILD.NUMBER = ? ";
        ArrayList<MavenDependency> results = new ArrayList<MavenDependency>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(dependenciesSql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenDependency artifact = new MavenDependency();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setSnapshot(artifact.getVersion().endsWith("-SNAPSHOT"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setScope(rst.getString("scope"));
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    public void recordParentProject(@NonNull String jobFullName, int buildNumber, @NonNull String parentGroupId, @NonNull String parentArtifactId, @NonNull String parentVersion, boolean ignoreUpstreamTriggers) {
        this.LOGGER.log(Level.FINE, "recordParentProject({0}#{1}, {2}:{3} ignoreUpstreamTriggers:{5}})", new Object[]{jobFullName, buildNumber, parentGroupId, parentArtifactId, parentVersion, ignoreUpstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long parentArtifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(parentGroupId, parentArtifactId, parentVersion, "pom", null);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO MAVEN_PARENT_PROJECT(ARTIFACT_ID, BUILD_ID, IGNORE_UPSTREAM_TRIGGERS) VALUES (?, ?, ?)");){
                stmt.setLong(1, parentArtifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setBoolean(3, ignoreUpstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void recordGeneratedArtifact(String jobFullName, int buildNumber, String groupId, String artifactId, String version, String type, String baseVersion, String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        this.LOGGER.log(Level.FINE, "recordGeneratedArtifact({0}#{1}, {2}:{3}:{4}:{5}, version:{6}, repositoryUrl:{7}, skipDownstreamTriggers:{8})", new Object[]{jobFullName, buildNumber, groupId, artifactId, baseVersion, type, version, repositoryUrl, skipDownstreamTriggers});
        long buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        long artifactPrimaryKey = this.getOrCreateArtifactPrimaryKey(groupId, artifactId, baseVersion, type, classifier);
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("INSERT INTO GENERATED_MAVEN_ARTIFACT(ARTIFACT_ID, BUILD_ID, VERSION, REPOSITORY_URL, EXTENSION, SKIP_DOWNSTREAM_TRIGGERS) VALUES (?, ?, ?, ?, ?, ?)");){
                stmt.setLong(1, artifactPrimaryKey);
                stmt.setLong(2, buildPrimaryKey);
                stmt.setString(3, version);
                stmt.setString(4, repositoryUrl);
                stmt.setString(5, extension);
                stmt.setBoolean(6, skipDownstreamTriggers);
                stmt.execute();
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void recordBuildUpstreamCause(String upstreamJobName, int upstreamBuildNumber, String downstreamJobName, int downstreamBuildNumber) {
        this.LOGGER.log(Level.FINE, "recordBuildUpstreamCause(upstreamBuild: {0}#{1}, downstreamBuild: {2}#{3})", new Object[]{upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "insert into JENKINS_BUILD_UPSTREAM_CAUSE (upstream_build_id, downstream_build_id) values (?, ?)";
            long upstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(upstreamJobName, upstreamBuildNumber);
            long downstreamBuildPrimaryKey = this.getOrCreateBuildPrimaryKey(downstreamJobName, downstreamBuildNumber);
            try (PreparedStatement stmt = cnn.prepareStatement(sql);){
                stmt.setLong(1, upstreamBuildPrimaryKey);
                stmt.setLong(2, downstreamBuildPrimaryKey);
                int rowCount = stmt.executeUpdate();
                if (rowCount != 1) {
                    this.LOGGER.log(Level.INFO, "More/less ({0}) than 1 record inserted in JENKINS_BUILD_UPSTREAM_CAUSE for upstreamBuild: {1}#{2}, downstreamBuild: {3}#{4}", new Object[]{rowCount, upstreamJobName, upstreamBuildNumber, downstreamJobName, downstreamBuildNumber});
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void renameJob(String oldFullName, String newFullName) {
        this.LOGGER.log(Level.FINER, "renameJob({0}, {1})", new Object[]{oldFullName, newFullName});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET FULL_NAME = ? WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, newFullName);
                stmt.setString(2, oldFullName);
                stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "renameJob({0}, {1}): {2}", new Object[]{oldFullName, newFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void deleteJob(String jobFullName) {
        this.LOGGER.log(Level.FINER, "deleteJob({0})", new Object[]{jobFullName});
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("DELETE FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "deleteJob({0}): {1}", new Object[]{jobFullName, count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void deleteBuild(String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "deleteBuild({0}#{1})", new Object[]{jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();){
            Integer lastSuccessfulBuildNumber;
            Integer lastBuildNumber;
            Long jobPrimaryKey;
            cnn.setAutoCommit(false);
            try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID, LAST_BUILD_NUMBER, LAST_SUCCESSFUL_BUILD_NUMBER FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                stmt.setString(1, jobFullName);
                stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                try (ResultSet rst = stmt.executeQuery();){
                    if (rst.next()) {
                        jobPrimaryKey = rst.getLong("ID");
                        lastBuildNumber = rst.getInt("LAST_BUILD_NUMBER");
                        lastSuccessfulBuildNumber = rst.getInt("LAST_SUCCESSFUL_BUILD_NUMBER");
                    } else {
                        jobPrimaryKey = null;
                        lastBuildNumber = null;
                        lastSuccessfulBuildNumber = null;
                    }
                }
            }
            if (jobPrimaryKey == null) {
                this.LOGGER.log(Level.FINE, "No record found for job {0}", new Object[]{jobFullName});
                return;
            }
            if (buildNumber == lastBuildNumber || buildNumber == lastSuccessfulBuildNumber) {
                Integer newLastBuildNumber = lastBuildNumber == buildNumber ? null : lastBuildNumber;
                Integer newLastSuccessfulBuildNumber = lastSuccessfulBuildNumber == buildNumber ? null : lastSuccessfulBuildNumber;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT JENKINS_BUILD.number, JENKINS_BUILD.result_id FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER != ? ORDER BY NUMBER DESC");){
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    stmt.setFetchSize(5);
                    try (ResultSet rst = stmt.executeQuery();){
                        while (rst.next() && (newLastBuildNumber == null || newLastSuccessfulBuildNumber == null)) {
                            int currentBuildNumber = rst.getInt("number");
                            int currentBuildResultId = rst.getInt("result_id");
                            if (newLastBuildNumber == null) {
                                newLastBuildNumber = currentBuildNumber;
                            }
                            if (newLastSuccessfulBuildNumber != null || Result.SUCCESS.ordinal != currentBuildResultId) continue;
                            newLastSuccessfulBuildNumber = currentBuildNumber;
                        }
                    }
                }
                stmt = cnn.prepareStatement("UPDATE JENKINS_JOB SET LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? WHERE ID = ?");
                try {
                    stmt.setInt(1, newLastBuildNumber);
                    stmt.setInt(2, newLastSuccessfulBuildNumber);
                    stmt.setLong(3, jobPrimaryKey);
                    stmt.execute();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            stmt = cnn.prepareStatement("DELETE FROM JENKINS_BUILD WHERE JOB_ID = ? AND NUMBER = ?");
            try {
                stmt.setLong(1, jobPrimaryKey);
                stmt.setInt(2, buildNumber);
                int count = stmt.executeUpdate();
                this.LOGGER.log(Level.FINE, "deleteJob({0}#{1}): {2}", new Object[]{jobFullName, buildNumber, count});
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    public void cleanup() {
        try (Connection cnn = this.ds.getConnection();){
            cnn.setAutoCommit(false);
            String sql = "DELETE FROM MAVEN_ARTIFACT WHERE ID NOT IN (SELECT DISTINCT ARTIFACT_ID FROM MAVEN_DEPENDENCY UNION SELECT DISTINCT ARTIFACT_ID FROM GENERATED_MAVEN_ARTIFACT)";
            try (Statement stmt = cnn.createStatement();){
                int count = stmt.executeUpdate(sql);
                this.LOGGER.log(Level.FINE, "cleanup(): {0}", new Object[]{count});
            }
            cnn.commit();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized long getOrCreateBuildPrimaryKey(String jobFullName, int buildNumber) {
        long l;
        block52: {
            Connection cnn = this.ds.getConnection();
            try {
                cnn.setAutoCommit(false);
                Long jobPrimaryKey = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
                    stmt.setString(1, jobFullName);
                    stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                    try (ResultSet rst = stmt.executeQuery();){
                        if (rst.next()) {
                            jobPrimaryKey = rst.getLong(1);
                        }
                    }
                }
                if (jobPrimaryKey == null) {
                    stmt = cnn.prepareStatement("INSERT INTO JENKINS_JOB(FULL_NAME, JENKINS_MASTER_ID) VALUES (?, ?)", 1);
                    try {
                        stmt.setString(1, jobFullName);
                        stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
                        stmt.execute();
                        jobPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                Long buildPrimaryKey = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_BUILD WHERE JOB_ID=? AND NUMBER=?");){
                    stmt.setLong(1, jobPrimaryKey);
                    stmt.setInt(2, buildNumber);
                    try (ResultSet rst = stmt.executeQuery();){
                        if (rst.next()) {
                            buildPrimaryKey = rst.getLong(1);
                        }
                    }
                }
                if (buildPrimaryKey == null) {
                    stmt = cnn.prepareStatement("INSERT INTO JENKINS_BUILD(JOB_ID, NUMBER) VALUES (?, ?)", 1);
                    try {
                        stmt.setLong(1, jobPrimaryKey);
                        stmt.setInt(2, buildNumber);
                        stmt.execute();
                        buildPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                cnn.commit();
                l = buildPrimaryKey;
                if (cnn == null) break block52;
            }
            catch (Throwable throwable) {
                try {
                    if (cnn != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException(e);
                }
            }
            cnn.close();
        }
        return l;
    }

    protected Long getGeneratedPrimaryKey(PreparedStatement stmt, String column) throws SQLException {
        long jobPrimaryKey;
        block7: {
            try (ResultSet rst = stmt.getGeneratedKeys();){
                if (rst.next()) {
                    jobPrimaryKey = rst.getLong(1);
                    break block7;
                }
                throw new IllegalStateException();
            }
        }
        return jobPrimaryKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getOrCreateArtifactPrimaryKey(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull String type, @Nullable String classifier) {
        try (Connection cnn = this.ds.getConnection();){
            PreparedStatement stmt;
            Long artifactPrimaryKey;
            block42: {
                ResultSet rst;
                cnn.setAutoCommit(false);
                artifactPrimaryKey = null;
                if (classifier == null) {
                    stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER is NULL");
                    try {
                        stmt.setString(1, groupId);
                        stmt.setString(2, artifactId);
                        stmt.setString(3, version);
                        stmt.setString(4, type);
                        rst = stmt.executeQuery();
                        try {
                            if (rst.next()) {
                                artifactPrimaryKey = rst.getLong(1);
                            }
                            break block42;
                        }
                        finally {
                            if (rst != null) {
                                rst.close();
                            }
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                stmt = cnn.prepareStatement("SELECT ID FROM MAVEN_ARTIFACT WHERE GROUP_ID = ? AND ARTIFACT_ID = ? AND VERSION = ? AND TYPE = ? AND CLASSIFIER = ?");
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    rst = stmt.executeQuery();
                    try {
                        if (rst.next()) {
                            artifactPrimaryKey = rst.getLong(1);
                        }
                    }
                    finally {
                        if (rst != null) {
                            rst.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            if (artifactPrimaryKey == null) {
                stmt = cnn.prepareStatement("INSERT INTO MAVEN_ARTIFACT(GROUP_ID, ARTIFACT_ID, VERSION, TYPE, CLASSIFIER) VALUES (?, ?, ?, ?, ?)", 1);
                try {
                    stmt.setString(1, groupId);
                    stmt.setString(2, artifactId);
                    stmt.setString(3, version);
                    stmt.setString(4, type);
                    stmt.setString(5, classifier);
                    stmt.execute();
                    artifactPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            cnn.commit();
            long l = artifactPrimaryKey;
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected synchronized void initializeDatabase() {
        try (Connection cnn = this.ds.getConnection();){
            String sqlScriptPath;
            InputStream sqlScriptInputStream;
            cnn.setAutoCommit(false);
            int initialSchemaVersion = this.getSchemaVersion(cnn);
            this.LOGGER.log(Level.FINE, "Initialise database. Current schema version: {0}", new Object[]{initialSchemaVersion});
            DecimalFormat numberFormat = new DecimalFormat("00");
            int idx = initialSchemaVersion;
            while ((sqlScriptInputStream = ClassUtils.getResourceAsStream(sqlScriptPath = "sql/" + this.getJdbcScheme() + "/" + numberFormat.format(++idx) + "_migration.sql")) != null) {
                String sqlScript;
                try {
                    sqlScript = IOUtils.toString((InputStream)sqlScriptInputStream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeIoException("Exception reading " + sqlScriptPath, e);
                }
                this.LOGGER.log(Level.FINE, "Execute database migration script {0}", sqlScriptPath);
                for (String sqlCommand : sqlScript.split(";")) {
                    if ((sqlCommand = sqlCommand.trim()).isEmpty()) continue;
                    try (Statement stmt = cnn.createStatement();){
                        this.LOGGER.log(Level.FINER, "Execute command {0}", sqlCommand);
                        stmt.execute(sqlCommand);
                    }
                    catch (SQLException e) {
                        this.LOGGER.log(Level.SEVERE, "Failed to run SQL {0} from script {1}: {2}", new Object[]{sqlCommand, sqlScriptPath, e.getMessage()});
                        this.handleDatabaseInitialisationException(e);
                    }
                }
                String className = "org.jenkinsci.plugins.pipeline.maven.db.migration." + this.getJdbcScheme() + ".MigrationStep" + idx;
                try {
                    MigrationStep migrationStep = (MigrationStep)Class.forName(className).newInstance();
                    this.LOGGER.log(Level.FINE, "Execute database migration step {0}", migrationStep.getClass().getName());
                    migrationStep.execute(cnn, this.getJenkinsDetails());
                }
                catch (ClassNotFoundException e) {
                    this.LOGGER.log(Level.FINER, "Migration step {0} not found", new Object[]{className});
                }
                catch (Exception e) {
                    cnn.rollback();
                    throw new RuntimeException(e);
                }
                cnn.commit();
            }
            int newSchemaVersion = this.getSchemaVersion(cnn);
            if (newSchemaVersion == 0) {
                throw new IllegalStateException("Failure to load database DDL files. Files 'sql/" + this.getJdbcScheme() + "/xxx_migration.sql' NOT found in the Thread Context Class Loader.  Pipeline Maven Plugin may be installed in an unsupported manner (thread.contextClassLoader: " + String.valueOf(Thread.currentThread().getContextClassLoader()) + ", classLoader: " + String.valueOf(ClassUtils.class.getClassLoader()) + ")");
            }
            if (newSchemaVersion == initialSchemaVersion) {
            } else {
                this.LOGGER.log(Level.INFO, "Database successfully migrated from version {0} to version {1}", new Object[]{initialSchemaVersion, newSchemaVersion});
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    protected void handleDatabaseInitialisationException(SQLException e) {
        throw new RuntimeSqlException(e);
    }

    public abstract String getJdbcScheme();

    protected int getSchemaVersion(Connection cnn) throws SQLException {
        int schemaVersion;
        block17: {
            try (Statement stmt = cnn.createStatement();){
                try (ResultSet rst = stmt.executeQuery("SELECT * FROM VERSION");){
                    schemaVersion = rst.next() ? rst.getInt(1) : 0;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 42102) {
                        schemaVersion = 0;
                        break block17;
                    }
                    if (e.getErrorCode() == 1146) {
                        schemaVersion = 0;
                        break block17;
                    }
                    if ("42P01".equals(e.getSQLState())) {
                        schemaVersion = 0;
                        cnn.rollback();
                        break block17;
                    }
                    throw new RuntimeSqlException(e);
                }
            }
        }
        return schemaVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void testDatabase() throws RuntimeSqlException {
        try (Connection cnn = this.ds.getConnection();){
            List<String> tables = Arrays.asList("MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT");
            for (String table : tables) {
                try {
                    Statement stmt = cnn.createStatement();
                    try {
                        ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                        try {
                            if (!rst.next()) throw new IllegalStateException("Exception testing table '" + table + "'");
                            int count = rst.getInt(1);
                            this.LOGGER.log(Level.FINE, "Table {0}: {1} rows", new Object[]{table, count});
                        }
                        finally {
                            if (rst == null) continue;
                            rst.close();
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException("Exception testing table '" + table + "' on " + cnn.toString(), e);
                    return;
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Deprecated
    @NonNull
    public List<String> listDownstreamJobs(@NonNull String jobFullName, int buildNumber) {
        List<String> downstreamJobs = this.listDownstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        downstreamJobs.addAll(this.listDownstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        downstreamJobs.remove(jobFullName);
        return downstreamJobs;
    }

    @NonNull
    public Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifact(@NonNull String jobFullName, int buildNumber) {
        MavenArtifact mavenArtifact;
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnMavenDependencies = this.listDownstreamJobsByArtifactBasedOnMavenDependencies(jobFullName, buildNumber);
        this.LOGGER.log(Level.FINER, "Got downstreamJobsByArtifactBasedOnMavenDependencies for job named {0} and build #{1}: {2}", new Object[]{jobFullName, buildNumber, downstreamJobsByArtifactBasedOnMavenDependencies});
        Map<MavenArtifact, SortedSet<String>> downstreamJobsByArtifactBasedOnParentProjectDependencies = this.listDownstreamJobsByArtifactBasedOnParentProjectDependencies(jobFullName, buildNumber);
        this.LOGGER.log(Level.FINER, "Got downstreamJobsByArtifactBasedOnParentProjectDependencies for job named {0} and build #{1}: {2}", new Object[]{jobFullName, buildNumber, downstreamJobsByArtifactBasedOnParentProjectDependencies});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>(downstreamJobsByArtifactBasedOnMavenDependencies);
        for (Map.Entry<MavenArtifact, SortedSet<String>> entry : downstreamJobsByArtifactBasedOnParentProjectDependencies.entrySet()) {
            mavenArtifact = entry.getKey();
            if (results.containsKey(mavenArtifact)) {
                ((SortedSet)results.get(mavenArtifact)).addAll((Collection)entry.getValue());
                continue;
            }
            results.put(mavenArtifact, new TreeSet<String>(entry.getValue()));
        }
        this.LOGGER.log(Level.FINER, "Got results for job named {0} and build #{1}: {2}", new Object[]{jobFullName, buildNumber, results});
        Iterator it = results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            mavenArtifact = (MavenArtifact)entry.getKey();
            SortedSet jobs = (SortedSet)entry.getValue();
            boolean removed = jobs.remove(jobFullName);
            if (!removed) continue;
            this.LOGGER.log(Level.FINER, "Remove {0} from downstreamJobs of artifact {1}", new Object[]{jobFullName, mavenArtifact});
            if (!jobs.isEmpty()) continue;
            it.remove();
        }
        return results;
    }

    @NonNull
    public SortedSet<String> listDownstreamJobs(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @Nullable String baseVersion, @NonNull String type, @Nullable String classifier) {
        return this.listDownstreamPipelinesBasedOnMavenDependencies(groupId, artifactId, baseVersion == null ? version : baseVersion, type, classifier);
    }

    protected SortedSet<String> listDownstreamPipelinesBasedOnMavenDependencies(@NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull String type, @Nullable String classifier) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnMavenDependencies({0}:{1}:{2}:{3}:{4})", new Object[]{groupId, artifactId, version, type, classifier});
        String sql = "select distinct downstream_job.full_name \nfrom MAVEN_ARTIFACT  \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere MAVEN_ARTIFACT.group_id = ? and MAVEN_ARTIFACT.artifact_id = ? and MAVEN_ARTIFACT.version = ? and MAVEN_ARTIFACT.type = ? and (MAVEN_ARTIFACT.classifier = ? or (MAVEN_ARTIFACT.classifier is null and ? is null)) and downstream_job.jenkins_master_id = ?";
        TreeSet<String> downstreamJobsFullNames = new TreeSet<String>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, groupId);
            stmt.setString(2, artifactId);
            stmt.setString(3, version);
            stmt.setString(4, type);
            stmt.setString(5, classifier);
            stmt.setString(6, classifier);
            stmt.setLong(7, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnMavenDependencies({0}:{1}:{2}:{3}): {4}", new Object[]{groupId, artifactId, version, type, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnMavenDependencies(@NonNull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamJobs({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobs({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnMavenDependencies(@NonNull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n    MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version as base_version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, \n   GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.extension \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setExtension(rst.getString("extension"));
                    String downstreamJobFullName = rst.getString("full_name");
                    results.computeIfAbsent(artifact, a -> new TreeSet()).add(downstreamJobFullName);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @Deprecated
    protected List<String> listDownstreamPipelinesBasedOnParentProjectDependencies(@NonNull String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        ArrayList<String> downstreamJobsFullNames = new ArrayList<String>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    downstreamJobsFullNames.add(rst.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, downstreamJobsFullNames});
        return downstreamJobsFullNames;
    }

    protected Map<MavenArtifact, SortedSet<String>> listDownstreamJobsByArtifactBasedOnParentProjectDependencies(String jobFullName, int buildNumber) {
        this.LOGGER.log(Level.FINER, "listDownstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{jobFullName, buildNumber});
        String sql = "select distinct downstream_job.full_name, \n   MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.version as base_version, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, \n   GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.extension \nfrom JENKINS_JOB as upstream_job \ninner join JENKINS_BUILD as upstream_build on upstream_job.id = upstream_build.job_id \ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false) \ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id \ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false) \ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id \ninner join JENKINS_JOB as downstream_job on (downstream_build.number = downstream_job.last_successful_build_number and downstream_build.job_id = downstream_job.id) \nwhere upstream_job.full_name = ? and upstream_job.jenkins_master_id = ? and upstream_build.number = ? and downstream_job.jenkins_master_id = ?";
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, jobFullName, buildNumber});
        HashMap<MavenArtifact, SortedSet<String>> results = new HashMap<MavenArtifact, SortedSet<String>>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setVersion(rst.getString("version"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    artifact.setExtension(rst.getString("extension"));
                    String downstreamJobFullName = rst.getString("full_name");
                    results.computeIfAbsent(artifact, a -> new TreeSet()).add(downstreamJobFullName);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listDownstreamJobsByArtifactBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{jobFullName, buildNumber, results});
        return results;
    }

    @NonNull
    public Map<String, Integer> listUpstreamJobs(@NonNull String jobFullName, int buildNumber) {
        Map<String, Integer> upstreamJobs = this.listUpstreamPipelinesBasedOnMavenDependencies(jobFullName, buildNumber);
        upstreamJobs.putAll(this.listUpstreamPipelinesBasedOnParentProjectDependencies(jobFullName, buildNumber));
        upstreamJobs.remove(jobFullName);
        return upstreamJobs;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnMavenDependencies(@NonNull String downstreamJobFullName, int downstreamBuildNumber) {
        Long jobPrimaryKey;
        this.LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement("SELECT ID FROM JENKINS_JOB WHERE FULL_NAME = ? AND JENKINS_MASTER_ID = ?");){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                jobPrimaryKey = rst.next() ? Long.valueOf(rst.getLong("ID")) : null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        if (jobPrimaryKey == null) {
            return new HashMap<String, Integer>();
        }
        String sql = "select distinct upstream_job.full_name, upstream_build.number\nfrom JENKINS_JOB as upstream_job\ninner join JENKINS_BUILD as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id  and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false)\ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id\ninner join MAVEN_DEPENDENCY on (MAVEN_DEPENDENCY.artifact_id = MAVEN_ARTIFACT.id and MAVEN_DEPENDENCY.ignore_upstream_triggers = false)\ninner join JENKINS_BUILD as downstream_build on MAVEN_DEPENDENCY.build_id = downstream_build.id\nwhere downstream_build.job_id = ? and downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setLong(1, jobPrimaryKey);
            stmt.setInt(2, downstreamBuildNumber);
            stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnMavenDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    protected Map<String, Integer> listUpstreamPipelinesBasedOnParentProjectDependencies(@NonNull String downstreamJobFullName, int downstreamBuildNumber) {
        this.LOGGER.log(Level.FINER, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1})", new Object[]{downstreamJobFullName, downstreamBuildNumber});
        String sql = "select distinct upstream_job.full_name, upstream_build.number\nfrom JENKINS_JOB as upstream_job\ninner join JENKINS_BUILD as upstream_build on (upstream_job.id = upstream_build.job_id and upstream_job.last_successful_build_number = upstream_build.number)\ninner join GENERATED_MAVEN_ARTIFACT on (upstream_build.id = GENERATED_MAVEN_ARTIFACT.build_id  and GENERATED_MAVEN_ARTIFACT.skip_downstream_triggers = false)\ninner join MAVEN_ARTIFACT on GENERATED_MAVEN_ARTIFACT.artifact_id = MAVEN_ARTIFACT.id\ninner join MAVEN_PARENT_PROJECT on (MAVEN_PARENT_PROJECT.artifact_id = MAVEN_ARTIFACT.id and MAVEN_PARENT_PROJECT.ignore_upstream_triggers = false)\ninner join JENKINS_BUILD as downstream_build on MAVEN_PARENT_PROJECT.build_id = downstream_build.id\ninner join JENKINS_JOB as downstream_job on downstream_build.job_id = downstream_job.id\nwhere downstream_job.full_name = ? and downstream_job.jenkins_master_id = ? and  downstream_build.number = ? and upstream_job.jenkins_master_id = ?";
        HashMap<String, Integer> upstreamJobsFullNames = new HashMap<String, Integer>();
        this.LOGGER.log(Level.FINER, "sql: {0}, jobFullName:{1}, buildNumber: {2}", new Object[]{sql, downstreamJobFullName, downstreamBuildNumber});
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(sql);){
            stmt.setString(1, downstreamJobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, downstreamBuildNumber);
            stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    upstreamJobsFullNames.put(rst.getString(1), rst.getInt(2));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        this.LOGGER.log(Level.FINE, "listUpstreamPipelinesBasedOnParentProjectDependencies({0}, {1}): {2}", new Object[]{downstreamJobFullName, downstreamBuildNumber, upstreamJobsFullNames});
        return upstreamJobsFullNames;
    }

    @NonNull
    public Map<String, Integer> listTransitiveUpstreamJobs(@NonNull String jobFullName, int buildNumber) {
        UpstreamMemory upstreamMemory = new UpstreamMemory();
        return this.listTransitiveUpstreamJobs(jobFullName, buildNumber, new HashMap<String, Integer>(), 0, upstreamMemory);
    }

    @NonNull
    public Map<String, Integer> listTransitiveUpstreamJobs(@NonNull String jobFullName, int buildNumber, UpstreamMemory upstreamMemory) {
        return this.listTransitiveUpstreamJobs(jobFullName, buildNumber, new HashMap<String, Integer>(), 0, upstreamMemory);
    }

    private Map<String, Integer> listTransitiveUpstreamJobs(@NonNull String jobFullName, int buildNumber, Map<String, Integer> transitiveUpstreamBuilds, int recursionDepth, UpstreamMemory upstreamMemory) {
        Map upstreamBuilds = upstreamMemory.listUpstreamJobs((PipelineMavenPluginDao)this, jobFullName, buildNumber);
        for (Map.Entry upstreamBuild : upstreamBuilds.entrySet()) {
            String upstreamJobFullName = (String)upstreamBuild.getKey();
            Integer upstreamBuildNumber = (Integer)upstreamBuild.getValue();
            if (transitiveUpstreamBuilds.containsKey(upstreamJobFullName)) continue;
            transitiveUpstreamBuilds.put(upstreamJobFullName, upstreamBuildNumber);
            if (recursionDepth >= OPTIMIZATION_MAX_RECURSION_DEPTH) continue;
            this.listTransitiveUpstreamJobs(upstreamJobFullName, upstreamBuildNumber, transitiveUpstreamBuilds, recursionDepth++, upstreamMemory);
        }
        return transitiveUpstreamBuilds;
    }

    @NonNull
    public List<MavenArtifact> getGeneratedArtifacts(@NonNull String jobFullName, @NonNull int buildNumber) {
        this.LOGGER.log(Level.FINER, "getGeneratedArtifacts({0}, {1})", new Object[]{jobFullName, buildNumber});
        String generatedArtifactsSql = "SELECT DISTINCT MAVEN_ARTIFACT.group_id, MAVEN_ARTIFACT.artifact_id, MAVEN_ARTIFACT.type, MAVEN_ARTIFACT.classifier, MAVEN_ARTIFACT.version as base_version, GENERATED_MAVEN_ARTIFACT.version as version, GENERATED_MAVEN_ARTIFACT.repository_url, GENERATED_MAVEN_ARTIFACT.extension FROM MAVEN_ARTIFACT  INNER JOIN GENERATED_MAVEN_ARTIFACT ON MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID INNER JOIN JENKINS_BUILD AS UPSTREAM_BUILD ON GENERATED_MAVEN_ARTIFACT.BUILD_ID = UPSTREAM_BUILD.ID  INNER JOIN JENKINS_JOB AS UPSTREAM_JOB ON UPSTREAM_BUILD.JOB_ID = UPSTREAM_JOB.ID  WHERE    UPSTREAM_JOB.FULL_NAME = ? AND   UPSTREAM_JOB.JENKINS_MASTER_ID = ? AND   UPSTREAM_BUILD.NUMBER = ? ";
        ArrayList<MavenArtifact> results = new ArrayList<MavenArtifact>();
        try (Connection cnn = this.ds.getConnection();
             PreparedStatement stmt = cnn.prepareStatement(generatedArtifactsSql);){
            stmt.setString(1, jobFullName);
            stmt.setLong(2, this.getJenkinsMasterPrimaryKey(cnn));
            stmt.setInt(3, buildNumber);
            try (ResultSet rst = stmt.executeQuery();){
                while (rst.next()) {
                    MavenArtifact artifact = new MavenArtifact();
                    artifact.setGroupId(rst.getString("group_id"));
                    artifact.setArtifactId(rst.getString("artifact_id"));
                    artifact.setBaseVersion(rst.getString("base_version"));
                    artifact.setType(rst.getString("type"));
                    artifact.setClassifier(rst.getString("classifier"));
                    String version = rst.getString("version");
                    if (version == null || version.isEmpty()) {
                        version = rst.getString("base_version");
                    }
                    artifact.setVersion(version);
                    artifact.setRepositoryUrl(rst.getString("repository_url"));
                    artifact.setExtension(rst.getString("extension"));
                    artifact.setSnapshot(artifact.getVersion().endsWith("-SNAPSHOT"));
                    results.add(artifact);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        Collections.sort(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Long getJenkinsMasterPrimaryKey(Connection cnn) throws SQLException {
        block36: {
            if (this.jenkinsMasterPrimaryKey == null) {
                String jenkinsMasterLegacyInstanceId = this.getJenkinsDetails().getMasterLegacyInstanceId();
                String jenkinsMasterUrl = this.getJenkinsDetails().getMasterRootUrl();
                String jenkinsMasterUrlValueInDb = null;
                try (PreparedStatement stmt = cnn.prepareStatement("SELECT ID, URL FROM JENKINS_MASTER WHERE LEGACY_INSTANCE_ID=?");){
                    stmt.setString(1, jenkinsMasterLegacyInstanceId);
                    try (ResultSet rst = stmt.executeQuery();){
                        if (rst.next()) {
                            this.jenkinsMasterPrimaryKey = rst.getLong("ID");
                            jenkinsMasterUrlValueInDb = rst.getString("URL");
                        }
                    }
                }
                if (this.jenkinsMasterPrimaryKey == null) {
                    try {
                        stmt = cnn.prepareStatement("INSERT INTO JENKINS_MASTER(LEGACY_INSTANCE_ID, URL) values (?, ?)", 1);
                        try {
                            stmt.setString(1, jenkinsMasterLegacyInstanceId);
                            stmt.setString(2, jenkinsMasterUrl);
                            stmt.execute();
                            this.jenkinsMasterPrimaryKey = this.getGeneratedPrimaryKey(stmt, "ID");
                            break block36;
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                    finally {
                        cnn.commit();
                    }
                }
                if (!Objects.equals(jenkinsMasterUrl, jenkinsMasterUrlValueInDb)) {
                    this.LOGGER.log(Level.INFO, "Update url from \"{0}\" to \"{1}\" for master with legacyId {2}", new Object[]{jenkinsMasterUrlValueInDb, jenkinsMasterUrl, jenkinsMasterLegacyInstanceId});
                    try {
                        stmt = cnn.prepareStatement("UPDATE JENKINS_MASTER set URL = ? where ID = ?");
                        try {
                            stmt.setString(1, jenkinsMasterUrl);
                            stmt.setLong(2, this.jenkinsMasterPrimaryKey);
                            int count = stmt.executeUpdate();
                            if (count != 1) {
                                this.LOGGER.warning("Updated more/less than 1 JENKINS_MASTER.URL=" + jenkinsMasterUrl + " for ID=" + this.jenkinsMasterPrimaryKey);
                            }
                        }
                        finally {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                    }
                    finally {
                        cnn.commit();
                    }
                }
            }
        }
        return this.jenkinsMasterPrimaryKey;
    }

    protected MigrationStep.JenkinsDetails getJenkinsDetails() {
        return new MigrationStep.JenkinsDetails();
    }

    public String toPrettyString() {
        ArrayList<CallSite> prettyStrings = new ArrayList<CallSite>();
        try (Connection cnn = this.ds.getConnection();){
            prettyStrings.add((CallSite)((Object)("JDBC URL: " + cnn.getMetaData().getURL())));
            List<String> tables = Arrays.asList("JENKINS_MASTER", "MAVEN_ARTIFACT", "JENKINS_JOB", "JENKINS_BUILD", "MAVEN_DEPENDENCY", "GENERATED_MAVEN_ARTIFACT", "MAVEN_PARENT_PROJECT", "JENKINS_BUILD_UPSTREAM_CAUSE");
            for (String table : tables) {
                try {
                    Statement stmt = cnn.createStatement();
                    try {
                        ResultSet rst = stmt.executeQuery("SELECT count(*) FROM " + table);
                        try {
                            if (rst.next()) {
                                int count = rst.getInt(1);
                                prettyStrings.add((CallSite)((Object)("Table " + table + ": " + count + " rows")));
                                continue;
                            }
                            prettyStrings.add((CallSite)((Object)("Table " + table + ": #IllegalStateException 'select count(*)' didn't return any row#")));
                        }
                        finally {
                            if (rst == null) continue;
                            rst.close();
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    prettyStrings.add((CallSite)((Object)("Table " + table + ": " + String.valueOf(e))));
                    this.LOGGER.log(Level.WARNING, "SQLException counting rows on " + table, e);
                }
            }
        }
        catch (SQLException e) {
            prettyStrings.add((CallSite)((Object)("SQLException getting a connection to " + String.valueOf(this.ds) + ": " + String.valueOf(e))));
            this.LOGGER.log(Level.WARNING, "SQLException getting a connection to " + String.valueOf(this.ds), e);
        }
        StringBuilder result = new StringBuilder(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)".") + " - " + this.getDatabaseDescription());
        for (String string : prettyStrings) {
            result.append("\r\n\t").append(string);
        }
        return result.toString();
    }

    protected String getDatabaseDescription() {
        String string;
        block8: {
            Connection cnn = this.ds.getConnection();
            try {
                DatabaseMetaData metaData = cnn.getMetaData();
                string = metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
                if (cnn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cnn != null) {
                        try {
                            cnn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return "#" + e.toString() + "#";
                }
            }
            cnn.close();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void updateBuildOnCompletion(@NonNull String jobFullName, int buildNumber, int buildResultOrdinal, long startTimeInMillis, long durationInMillis) {
        this.LOGGER.log(Level.FINE, "updateBuildOnCompletion({0}, {1}, result: {2}, startTime): {3}, duration: {4}", new Object[]{jobFullName, buildNumber, buildResultOrdinal, startTimeInMillis, durationInMillis});
        buildPrimaryKey = this.getOrCreateBuildPrimaryKey(jobFullName, buildNumber);
        try {
            cnn = this.ds.getConnection();
            try {
                cnn.setAutoCommit(false);
                stmt = cnn.prepareStatement("UPDATE JENKINS_BUILD SET RESULT_ID = ?, START_TIME = ?, DURATION_IN_MILLIS = ? WHERE ID = ?");
                try {
                    stmt.setInt(1, buildResultOrdinal);
                    stmt.setTimestamp(2, new Timestamp(startTimeInMillis));
                    stmt.setLong(3, durationInMillis);
                    stmt.setLong(4, buildPrimaryKey);
                    count = stmt.executeUpdate();
                    if (count != 1) {
                        this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_BUILD record updated (" + count + ") for " + jobFullName + "#" + buildNumber + ", buildPrimaryKey=" + buildPrimaryKey);
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                if (Result.SUCCESS.ordinal == buildResultOrdinal) {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ?, LAST_SUCCESSFUL_BUILD_NUMBER = ? where FULL_NAME = ? and JENKINS_MASTER_ID = ?");
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setInt(2, buildNumber);
                        stmt.setString(3, jobFullName);
                        stmt.setLong(4, this.getJenkinsMasterPrimaryKey(cnn));
                        count = stmt.executeUpdate();
                        if (count == 1) ** GOTO lbl50
                        this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_JOB record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                } else {
                    stmt = cnn.prepareStatement("UPDATE JENKINS_JOB set LAST_BUILD_NUMBER = ? where FULL_NAME = ?  and JENKINS_MASTER_ID = ?");
                    try {
                        stmt.setInt(1, buildNumber);
                        stmt.setString(2, jobFullName);
                        stmt.setLong(3, this.getJenkinsMasterPrimaryKey(cnn));
                        count = stmt.executeUpdate();
                        if (count != 1) {
                            this.LOGGER.log(Level.WARNING, "updateBuildOnCompletion - more/less than 1 JENKINS_JOB record updated (" + count + ") for " + jobFullName + "#" + buildNumber);
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                cnn.commit();
            }
            finally {
                if (cnn != null) {
                    cnn.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException("Exception updating build " + jobFullName + "#" + buildNumber + " with result " + buildResultOrdinal, e);
        }
    }

    @NonNull
    protected DataSource getDataSource() {
        return this.ds;
    }

    public void close() throws IOException {
        if (this.ds instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)this.ds);
            closeable.close();
        }
    }

    private class JDBCDaoBuilder
    implements PipelineMavenPluginDao.Builder {
        protected final Logger LOGGER = Logger.getLogger(JDBCDaoBuilder.class.getName());
        private final Class<?> pipelineMavenPluginDaoClass;

        public JDBCDaoBuilder(Class<?> pipelineMavenPluginDaoClass) {
            this.pipelineMavenPluginDaoClass = pipelineMavenPluginDaoClass;
        }

        public PipelineMavenPluginDao build(PipelineMavenPluginDao.Builder.Config config) {
            PipelineMavenPluginNullDao dao;
            Jenkins j = Jenkins.get();
            try {
                String jdbcPassword;
                String jdbcUserName;
                Optional<PipelineMavenPluginDao> optionalPipelineMavenPluginDao;
                String jdbcUrl = config.getJdbcUrl();
                if (StringUtils.isBlank((String)jdbcUrl) && (optionalPipelineMavenPluginDao = ExtensionList.lookup(PipelineMavenPluginDao.class).stream().filter(pipelineMavenPluginDao -> pipelineMavenPluginDao.getClass().getName().equals(this.pipelineMavenPluginDaoClass.getName())).findFirst()).isPresent()) {
                    jdbcUrl = optionalPipelineMavenPluginDao.get().getDefaultJdbcUrl();
                }
                if (StringUtils.isBlank((String)config.getCredentialsId()) && !AbstractPipelineMavenPluginDao.this.acceptNoCredentials()) {
                    throw new IllegalStateException("No credentials defined for JDBC URL '" + jdbcUrl + "'");
                }
                UsernamePasswordCredentials jdbcCredentials = null;
                if (!StringUtils.isBlank((String)config.getCredentialsId())) {
                    jdbcCredentials = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(UsernamePasswordCredentials.class, (ItemGroup)j, (Authentication)ACL.SYSTEM, (List)Collections.EMPTY_LIST), (CredentialsMatcher)CredentialsMatchers.withId((String)config.getCredentialsId()));
                }
                if (jdbcCredentials == null && this.pipelineMavenPluginDaoClass == PipelineMavenPluginH2Dao.class) {
                    jdbcUserName = "sa";
                    jdbcPassword = "sa";
                } else {
                    if (jdbcCredentials == null) {
                        throw new IllegalStateException("Credentials '" + config.getCredentialsId() + "' defined for JDBC URL '" + jdbcUrl + "' NOT found");
                    }
                    jdbcUserName = jdbcCredentials.getUsername();
                    jdbcPassword = Secret.toString((Secret)jdbcCredentials.getPassword());
                }
                HikariConfig dsConfig = AbstractPipelineMavenPluginDao.createHikariConfig(config.getProperties(), jdbcUrl, jdbcUserName, jdbcPassword);
                dsConfig.setAutoCommit(false);
                try {
                    DriverManager.getDriver(jdbcUrl);
                }
                catch (SQLException e) {
                    if ("08001".equals(e.getSQLState()) && 0 == e.getErrorCode()) {
                        if (jdbcUrl.startsWith("jdbc:h2:")) {
                            try {
                                Class.forName("org.h2.Driver");
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new IllegalStateException("H2 driver should be bundled with this plugin");
                            }
                        } else if (jdbcUrl.startsWith("jdbc:mysql:")) {
                            try {
                                Class.forName("com.mysql.cj.jdbc.Driver");
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new RuntimeException("MySql driver 'com.mysql.cj.jdbc.Driver' not found. Please install the 'MySQL Database Plugin' to install the MySql driver");
                            }
                        } else if (jdbcUrl.startsWith("jdbc:postgresql:")) {
                            try {
                                Class.forName("org.postgresql.Driver");
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new RuntimeException("PostgreSQL driver 'org.postgresql.Driver' not found. Please install the 'PostgreSQL Database Plugin' to install the PostgreSQL driver");
                            }
                        } else {
                            throw new IllegalArgumentException("Unsupported database type in JDBC URL " + jdbcUrl);
                        }
                        DriverManager.getDriver(jdbcUrl);
                    }
                    throw e;
                }
                this.LOGGER.log(Level.INFO, "Connect to database {0} with username {1}", new Object[]{jdbcUrl, jdbcUserName});
                HikariDataSource ds = new HikariDataSource(dsConfig);
                try {
                    dao = new MonitoringPipelineMavenPluginDaoDecorator((PipelineMavenPluginDao)new CustomTypePipelineMavenPluginDaoDecorator((PipelineMavenPluginDao)this.pipelineMavenPluginDaoClass.getConstructor(DataSource.class).newInstance(ds)));
                }
                catch (Exception e) {
                    throw new SQLException("Exception connecting to '" + jdbcUrl + "' with credentials '" + config.getCredentialsId() + "' (" + jdbcUserName + "/***) and DAO " + this.getClass().getSimpleName(), e);
                }
            }
            catch (RuntimeException | SQLException e) {
                this.LOGGER.log(Level.WARNING, "Exception creating database dao, skip", e);
                dao = new PipelineMavenPluginNullDao();
            }
            return dao;
        }

        /*
         * Exception decompiling
         */
        public FormValidation validateConfiguration(PipelineMavenPluginDao.Builder.Config config) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 54[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

