/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jenkinsci.plugins.pipeline.maven.dao.CacheStats;
import org.jenkinsci.plugins.pipeline.maven.dao.MonitoringPipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;

public class UpstreamMemory {
    private static final AtomicInteger HITS = new AtomicInteger();
    private static final AtomicInteger MISSES = new AtomicInteger();
    private Map<String, Map<String, Integer>> upstreams = new HashMap<String, Map<String, Integer>>();

    public Map<String, Integer> listUpstreamJobs(PipelineMavenPluginDao dao, String jobFullName, int buildNumber) {
        String key = jobFullName + "#" + buildNumber;
        if (this.upstreams.containsKey(key)) {
            HITS.incrementAndGet();
        } else {
            MISSES.incrementAndGet();
        }
        return this.upstreams.computeIfAbsent(key, k -> dao.listUpstreamJobs(jobFullName, buildNumber));
    }

    static {
        MonitoringPipelineMavenPluginDaoDecorator.registerCacheStatsSupplier(() -> new CacheStats("listUpstreamJobs", HITS.get(), MISSES.get()));
    }
}

