/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.util.EnumConverter;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.beanutils.Converter;
import org.jenkinsci.plugins.conditionalbuildstep.ConditionalBuildStepHelper;
import org.kohsuke.stapler.Stapler;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Part of public API, reviewed all uses of Plugin are fully quantified in this class")
public class Plugin
extends hudson.Plugin {
    public static final String LOG_TAG = "[parameterized-trigger]";

    public void start() throws Exception {
        Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), ResultCondition.class);
    }

    public static boolean isConditionalBuildStepInstalled() {
        hudson.Plugin plugin = Jenkins.get().getPlugin("conditional-buildstep");
        return plugin != null && plugin.getWrapper().isActive();
    }

    @Extension
    public static final class RenameListener
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            ItemGroup context = item.getParent();
            String full = context.getFullName().isEmpty() ? "" : context.getFullName() + "/";
            String fullOldName = full + oldName;
            String fullNewName = full + newName;
            for (Project p : Jenkins.get().getAllItems(Project.class)) {
                boolean changed = false;
                for (BuildTrigger bt : p.getPublishersList().getAll(BuildTrigger.class)) {
                    for (BuildTriggerConfig buildTriggerConfig : bt.getConfigs()) {
                        changed |= buildTriggerConfig.onJobRenamed(p.getParent(), fullOldName, fullNewName);
                    }
                }
                for (TriggerBuilder tb : p.getBuildersList().getAll(TriggerBuilder.class)) {
                    for (BuildTriggerConfig buildTriggerConfig : tb.getConfigs()) {
                        changed |= buildTriggerConfig.onJobRenamed(p.getParent(), fullOldName, fullNewName);
                    }
                }
                if (Plugin.isConditionalBuildStepInstalled()) {
                    changed |= this.renameInConditionalBuildStep(p, oldName, newName);
                }
                if (!changed) continue;
                try {
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during rename from " + fullOldName + " to " + fullNewName, e);
                }
            }
        }

        public void onDeleted(Item item) {
            for (Project p : Jenkins.get().getAllItems(Project.class)) {
                BuildTriggerConfig c;
                String oldName = item.getFullName();
                boolean changed = false;
                for (BuildTrigger bt : p.getPublishersList().getAll(BuildTrigger.class)) {
                    ListIterator<BuildTriggerConfig> btc = bt.getConfigs().listIterator();
                    while (btc.hasNext()) {
                        c = btc.next();
                        if (!c.onDeleted(p.getParent(), oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        btc.remove();
                    }
                }
                for (TriggerBuilder tb : p.getBuildersList().getAll(TriggerBuilder.class)) {
                    ListIterator<BlockableBuildTriggerConfig> bbtc = tb.getConfigs().listIterator();
                    while (bbtc.hasNext()) {
                        c = bbtc.next();
                        if (!c.onDeleted(p.getParent(), oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        bbtc.remove();
                    }
                }
                if (Plugin.isConditionalBuildStepInstalled()) {
                    changed |= this.deleteInConditionalBuildStep(p, oldName);
                }
                if (!changed) continue;
                try {
                    for (BuildTrigger bt : p.getPublishersList().getAll(BuildTrigger.class)) {
                        if (!bt.getConfigs().isEmpty()) continue;
                        p.getPublishersList().remove((Object)bt);
                    }
                    for (TriggerBuilder tb : p.getBuildersList().getAll(TriggerBuilder.class)) {
                        if (!tb.getConfigs().isEmpty()) continue;
                        p.getBuildersList().remove((Object)tb);
                    }
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during remove of " + oldName, e);
                }
            }
        }

        private boolean renameInConditionalBuildStep(Project<?, ?> p, String oldName, String newName) {
            boolean changed = false;
            List containedBuilders = ConditionalBuildStepHelper.getContainedBuilders(p, TriggerBuilder.class);
            for (TriggerBuilder triggerBuilder : containedBuilders) {
                for (BuildTriggerConfig buildTriggerConfig : triggerBuilder.getConfigs()) {
                    changed |= buildTriggerConfig.onJobRenamed(p.getParent(), oldName, newName);
                }
            }
            return changed;
        }

        private boolean deleteInConditionalBuildStep(Project<?, ?> p, String oldName) {
            boolean changed = false;
            List containedBuilders = ConditionalBuildStepHelper.getContainedBuilders(p, TriggerBuilder.class);
            for (TriggerBuilder triggerBuilder : containedBuilders) {
                ListIterator<BlockableBuildTriggerConfig> bbtc = triggerBuilder.getConfigs().listIterator();
                while (bbtc.hasNext()) {
                    BuildTriggerConfig c = bbtc.next();
                    if (!c.onDeleted(p.getParent(), oldName)) continue;
                    changed = true;
                    if (c.getProjects().length() != 0) continue;
                    bbtc.remove();
                }
            }
            return changed;
        }
    }
}

