/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.baremetal.jenkins.ssh;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.oracle.cloud.baremetal.jenkins.BaremetalCloud;
import com.oracle.cloud.baremetal.jenkins.JenkinsUtil;
import com.oracle.cloud.baremetal.jenkins.retry.LinearRetry;
import com.oracle.cloud.baremetal.jenkins.ssh.SshConnector;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class SshComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(SshComputerLauncher.class.getName());
    public static final String DEFAULT_SSH_USER = "opc";
    public static final int DEFAULT_SSH_PORT = 22;
    public static final String DEFAULT_SSH_PUBLIC_KEY = " ";
    public final String host;
    private final int sshPort;
    private final String sshUser;
    private final int connectTimeoutMillis;
    private final String privateKey;
    private final String jenkinsAgentUser;
    private final String initScript;
    private final int initScriptTimeoutSeconds;
    private String customJavaPath;
    private String customJVMOpts;
    private transient SSHUserPrivateKey sshCredentials;
    private boolean verificationStrategy;

    public SshComputerLauncher(String host, int connectTimeoutMillis, String jenkinsAgentUser, String customJavaPath, String customJVMOpts, String initScript, int initScriptTimeoutSeconds, String sshCredentialsId, boolean verificationStrategy) {
        this(host, connectTimeoutMillis, jenkinsAgentUser, customJavaPath, customJVMOpts, initScript, initScriptTimeoutSeconds, sshCredentialsId, 22, verificationStrategy);
    }

    public SshComputerLauncher(String host, int connectTimeoutMillis, String jenkinsAgentUser, String customJavaPath, String customJVMOpts, String initScript, int initScriptTimeoutSeconds, String sshCredentialsId, int sshPort, boolean verificationStrategy) {
        this.sshCredentials = (SSHUserPrivateKey)BaremetalCloud.matchCredentials(SSHUserPrivateKey.class, sshCredentialsId);
        this.host = host;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.privateKey = this.sshCredentials != null ? this.sshCredentials.getPrivateKey() : DEFAULT_SSH_PUBLIC_KEY;
        this.jenkinsAgentUser = jenkinsAgentUser;
        this.initScript = initScript;
        this.initScriptTimeoutSeconds = initScriptTimeoutSeconds;
        this.sshUser = this.sshCredentials != null ? this.sshCredentials.getUsername() : DEFAULT_SSH_USER;
        this.sshPort = sshPort;
        this.customJavaPath = customJavaPath == null || customJavaPath.trim().isEmpty() ? "" : customJavaPath;
        this.customJVMOpts = customJVMOpts == null || customJVMOpts.trim().isEmpty() ? DEFAULT_SSH_PUBLIC_KEY : DEFAULT_SSH_PUBLIC_KEY + customJVMOpts + DEFAULT_SSH_PUBLIC_KEY;
        this.verificationStrategy = verificationStrategy;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        Connection connection = null;
        try {
            connection = this.connect(listener);
            this.authenticate(connection, listener);
            String workingDirectory = this.getRemoteWorkingDirectory(computer);
            this.createRemoteDirectory(connection, workingDirectory, listener);
            this.runInitScript(connection, workingDirectory, listener);
            this.ensureJavaInstalled(connection, listener);
            this.copyAgentJar(connection, workingDirectory, listener);
            this.launchAgent(connection, workingDirectory, computer, listener);
        }
        catch (IOException | InterruptedException e) {
            this.tearDownConnection(connection, listener);
            listener.fatalError("SSH Agent launch failed on: " + this.sshUser + "@" + this.host + ":" + this.sshPort);
            throw e;
        }
    }

    private Connection connect(TaskListener listener) throws IOException {
        String uri = this.sshUser + "@" + this.host + ":" + this.sshPort;
        listener.getLogger().println("Connecting to ssh: " + uri);
        try {
            Connection connection = SshConnector.createConnection(this.host, this.sshPort);
            if (!this.verificationStrategy) {
                new LinearRetry<ConnectionInfo>(() -> SshConnector.connect(connection, this.connectTimeoutMillis, "No Verification")).run();
            } else {
                new LinearRetry<ConnectionInfo>(() -> SshConnector.connect(connection, this.connectTimeoutMillis, "Strict Verification")).run();
            }
            return connection;
        }
        catch (Exception e) {
            listener.fatalError("Failed to connect to ssh: " + uri);
            throw new IOException(e);
        }
    }

    private void authenticate(Connection connection, TaskListener listener) throws IOException {
        listener.getLogger().println("Authenticating with private key");
        try {
            boolean authenticated = connection.authenticateWithPublicKey(this.sshUser, this.privateKey.toCharArray(), null);
            if (!authenticated) {
                throw new IOException("SSH launch failed at authenticating to host: " + this.host);
            }
        }
        catch (IOException e) {
            listener.fatalError("Failed to authenticate");
            throw e;
        }
    }

    private void ensureJavaInstalled(Connection connection, TaskListener listener) throws IOException, InterruptedException {
        int ret;
        listener.getLogger().println("Verifying that Java is installed");
        if (this.customJavaPath == null || this.customJavaPath.trim().isEmpty()) {
            this.customJavaPath = "";
        }
        if ((ret = connection.exec(this.customJavaPath + "java -fullversion", (OutputStream)listener.getLogger())) != 0) {
            listener.fatalError("Agent does not have java installed");
            throw new IOException("Agent does not have java installed: " + this.host);
        }
    }

    private String getRemoteWorkingDirectory(SlaveComputer computer) {
        Slave agent = computer.getNode();
        if (agent == null || agent.getRemoteFS().trim().isEmpty()) {
            return ".";
        }
        return agent.getRemoteFS();
    }

    private void createRemoteDirectory(Connection connection, String remoteDirectory, TaskListener listener) throws IOException, InterruptedException {
        try {
            connection.exec("mkdir -p \"" + remoteDirectory + "\"", (OutputStream)listener.getLogger());
        }
        catch (IOException | InterruptedException e) {
            listener.fatalError("Failed to create remote working directory: " + remoteDirectory);
            throw e;
        }
    }

    private void runInitScript(Connection connection, String remoteDirectory, TaskListener listener) throws InterruptedException, IOException {
        if (this.initScript == null || this.initScript.trim().length() <= 0) {
            listener.getLogger().println("No init script to copy to remote agent");
            return;
        }
        listener.getLogger().println("Copying init script to remote agent using scp");
        try {
            SCPClient scp = connection.createSCPClient();
            scp.put(this.initScript.getBytes("UTF-8"), "init.sh", remoteDirectory, "0700");
            String initIndicatorFile = "~/.hudson-run-init";
            String initscriptModified = "if [[ -e ~/.hudson-run-init ]]; then \n echo 'Agent already initialized ~/.hudson-run-init exists';\nelse\n echo 'Running init script on agent';\n /bin/bash " + remoteDirectory + "/init.sh;\n if [ $? != 0 ]; then\n  exit 1;\n fi\n echo Creating ~/.hudson-run-init on agent;\n touch ~/.hudson-run-init;\n fi\n";
            scp.put(initscriptModified.getBytes("UTF-8"), "initModified.sh", remoteDirectory, "0700");
        }
        catch (IOException e) {
            listener.fatalError("Failed to copy init script");
            throw e;
        }
        listener.getLogger().println("Running init script on remote agent");
        Session initSession = null;
        Session testSession = null;
        try {
            initSession = connection.openSession();
            testSession = connection.openSession();
            testSession.requestDumbPTY();
            testSession.execCommand("cat ~/initModified.sh");
            initSession.requestDumbPTY();
            String initCommand = "/bin/bash " + remoteDirectory + "/initModified.sh;";
            initSession.execCommand(initCommand);
            IOUtils.copy((InputStream)initSession.getStdout(), (OutputStream)listener.getLogger());
            IOUtils.copy((InputStream)initSession.getStderr(), (OutputStream)listener.getLogger());
            initSession.getStdin().close();
            initSession.getStderr().close();
            int exitStatus = this.waitCompletion(initSession);
            if (exitStatus != 0) {
                String msg = "Init script on " + this.host + " finished with non-zero exit status: " + exitStatus;
                listener.getLogger().println(msg);
                throw new IOException(msg);
            }
        }
        catch (IOException e) {
            listener.fatalError("Failed to execute init script on remote agent");
            throw e;
        }
        finally {
            if (initSession != null) {
                initSession.close();
                testSession.close();
            }
        }
    }

    private void copyAgentJar(Connection connection, String remoteDirectory, TaskListener listener) throws IOException, InterruptedException {
        String deleteString = "sudo rm -f " + remoteDirectory + "/slave.jar";
        listener.getLogger().println("Deleting remote slave.jar if it exists prior to copy [" + deleteString + "]");
        try {
            connection.exec(deleteString, (OutputStream)listener.getLogger());
        }
        catch (IOException e) {
            listener.fatalError("Failed trying to delete slave.jar on remote agent [" + e.getMessage() + "] command=[" + deleteString + "]");
            throw e;
        }
        listener.getLogger().println("Copying slave.jar to remote agent using scp");
        try {
            SCPClient scp = connection.createSCPClient();
            scp.put(JenkinsUtil.getJenkinsInstance().getJnlpJars("slave.jar").readFully(), "slave.jar", remoteDirectory);
        }
        catch (IOException e) {
            listener.fatalError("Failed to copy slave.jar");
            throw e;
        }
    }

    private void launchAgent(final Connection connection, String remoteDirectory, SlaveComputer computer, final TaskListener listener) throws IOException, InterruptedException {
        String jarfile = remoteDirectory + "/slave.jar";
        String remotingOptions = "-workDir " + remoteDirectory + " -jar-cache " + remoteDirectory + "/jarCache";
        if (this.customJVMOpts == null || this.customJVMOpts.trim().isEmpty()) {
            this.customJVMOpts = DEFAULT_SSH_PUBLIC_KEY;
        }
        String launchString = this.customJavaPath + "java" + this.customJVMOpts + "-jar " + jarfile + DEFAULT_SSH_PUBLIC_KEY + remotingOptions;
        if (this.jenkinsAgentUser == null || this.jenkinsAgentUser.trim().isEmpty()) {
            listener.getLogger().println("Jenkins Agent User is empty, default opc.");
        } else {
            launchString = "sudo chown " + this.jenkinsAgentUser + DEFAULT_SSH_PUBLIC_KEY + jarfile + " && sudo -i -u " + this.jenkinsAgentUser + DEFAULT_SSH_PUBLIC_KEY + launchString;
        }
        listener.getLogger().println("Launching Agent (via Trilead SSH2 Connection): " + launchString);
        final Session session = connection.openSession();
        try {
            session.execCommand(launchString);
            computer.setChannel(session.getStdout(), session.getStdin(), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    SshComputerLauncher.this.tearDownSession(session, listener);
                    SshComputerLauncher.this.tearDownConnection(connection, listener);
                }
            });
        }
        catch (IOException e) {
            this.tearDownSession(session, listener);
            listener.fatalError("Failed to launch Agent");
            throw e;
        }
    }

    private int waitCompletion(Session session) throws InterruptedException {
        LOGGER.info("Timeout around for init script complete is " + this.initScriptTimeoutSeconds);
        for (int i = 0; i < this.initScriptTimeoutSeconds; ++i) {
            Integer r = session.getExitStatus();
            if (r != null) {
                return r;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return -1;
    }

    private void tearDownSession(Session session, TaskListener listener) {
        if (session == null) {
            return;
        }
        this.reportSeesionTerminationReason(session, listener);
        listener.getLogger().println("Closing SSH Session to: " + this.host);
        try {
            session.getStdout().close();
            session.close();
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while closing SSH Session to: " + this.host));
        }
    }

    private void reportSeesionTerminationReason(Session session, TaskListener listener) {
        String exitSignal;
        try {
            session.waitForCondition(96, 2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Integer exitCode = session.getExitStatus();
        if (exitCode != null) {
            listener.getLogger().println("Remote Agent has terminated with exit code: " + exitCode);
        }
        if ((exitSignal = session.getExitSignal()) != null) {
            listener.getLogger().println("SSH Sesson has terminated with exit signal: " + exitCode);
        }
    }

    private void tearDownConnection(Connection connection, TaskListener listener) {
        if (connection == null) {
            return;
        }
        this.reportConnectionTerminationReason(connection, listener);
        listener.getLogger().println("Closing SSH Connection to");
        try {
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Error while closing SSH Connection to: " + this.host));
        }
    }

    private void reportConnectionTerminationReason(Connection connection, TaskListener listener) {
        Throwable cause = connection.getReasonClosedCause();
        if (cause != null) {
            cause.printStackTrace(listener.error("Connection to SSH server lost"));
        }
    }
}

